/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy.id;

import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.server.core.DefaultSqlUpdate;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import com.avaje.ebeaninternal.server.deploy.DbReadContext;
import com.avaje.ebeaninternal.server.deploy.DbSqlContext;
import com.avaje.ebeaninternal.server.deploy.id.IdBinder;
import com.avaje.ebeaninternal.server.type.DataBind;
import java.sql.SQLException;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IdBinderEmbedded
implements IdBinder {
    private final BeanPropertyAssocOne<?> embIdProperty;
    private BeanProperty[] props;
    private BeanDescriptor<?> idDesc;
    private String idInValueSql;

    public IdBinderEmbedded(BeanPropertyAssocOne<?> embIdProperty) {
        this.embIdProperty = embIdProperty;
    }

    @Override
    public void initialise() {
        this.idDesc = this.embIdProperty.getTargetDescriptor();
        this.props = this.embIdProperty.getProperties();
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < this.props.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("?");
        }
        sb.append(")");
        this.idInValueSql = sb.toString();
    }

    @Override
    public void createLdapNameById(LdapName name, Object id) throws InvalidNameException {
        for (int i = 0; i < this.props.length; ++i) {
            Object v = this.props[i].getValue(id);
            Rdn rdn = new Rdn(this.props[i].getDbColumn(), v);
            name.add(rdn);
        }
    }

    @Override
    public void createLdapNameByBean(LdapName name, Object bean) throws InvalidNameException {
        Object id = this.embIdProperty.getValue(bean);
        this.createLdapNameById(name, id);
    }

    public BeanDescriptor<?> getIdBeanDescriptor() {
        return this.idDesc;
    }

    @Override
    public int getPropertyCount() {
        return this.props.length;
    }

    @Override
    public String getIdProperty() {
        return this.embIdProperty.getName();
    }

    @Override
    public BeanProperty findBeanProperty(String dbColumnName) {
        for (int i = 0; i < this.props.length; ++i) {
            if (!dbColumnName.equalsIgnoreCase(this.props[i].getDbColumn())) continue;
            return this.props[i];
        }
        return null;
    }

    @Override
    public boolean isComplexId() {
        return true;
    }

    @Override
    public String getDefaultOrderBy() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.props.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.embIdProperty.getName());
            sb.append(".");
            sb.append(this.props[i].getName());
        }
        return sb.toString();
    }

    @Override
    public BeanProperty[] getProperties() {
        return this.props;
    }

    @Override
    public void addIdInBindValue(SpiExpressionRequest request, Object value) {
        for (int i = 0; i < this.props.length; ++i) {
            request.addBindValue(this.props[i].getValue(value));
        }
    }

    @Override
    public void addIdInValueSql(SpiExpressionRequest request) {
        request.append(this.idInValueSql);
    }

    @Override
    public Object[] getIdValues(Object bean) {
        Object[] bindvalues = new Object[this.props.length];
        for (int i = 0; i < this.props.length; ++i) {
            bindvalues[i] = this.props[i].getValue(bean);
        }
        return bindvalues;
    }

    @Override
    public Object[] getBindValues(Object value) {
        Object[] bindvalues = new Object[this.props.length];
        for (int i = 0; i < this.props.length; ++i) {
            bindvalues[i] = this.props[i].getValue(value);
        }
        return bindvalues;
    }

    @Override
    public void bindId(DefaultSqlUpdate sqlUpdate, Object value) {
        for (int i = 0; i < this.props.length; ++i) {
            Object embFieldValue = this.props[i].getValue(value);
            sqlUpdate.addParameter(embFieldValue);
        }
    }

    @Override
    public void bindId(DataBind dataBind, Object value) throws SQLException {
        for (int i = 0; i < this.props.length; ++i) {
            Object embFieldValue = this.props[i].getValue(value);
            this.props[i].bind(dataBind, embFieldValue);
        }
    }

    @Override
    public void loadIgnore(DbReadContext ctx) {
        for (int i = 0; i < this.props.length; ++i) {
            this.props[i].loadIgnore(ctx);
        }
    }

    @Override
    public Object read(DbReadContext ctx) throws SQLException {
        Object embId = this.idDesc.createVanillaBean();
        boolean notNull = false;
        for (int i = 0; i < this.props.length; ++i) {
            Object value = this.props[i].readSet(ctx, embId, null);
            if (value == null) continue;
            notNull = true;
        }
        if (notNull) {
            return embId;
        }
        return null;
    }

    @Override
    public Object readSet(DbReadContext ctx, Object bean) throws SQLException {
        Object embId = this.read(ctx);
        if (embId != null) {
            this.embIdProperty.setValue(bean, embId);
            return embId;
        }
        return null;
    }

    @Override
    public void appendSelect(DbSqlContext ctx) {
        for (int i = 0; i < this.props.length; ++i) {
            this.props[i].appendSelect(ctx);
        }
    }

    @Override
    public String getAssocIdInValueExpr() {
        return this.idInValueSql;
    }

    @Override
    public String getAssocIdInExpr(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < this.props.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            if (prefix != null) {
                sb.append(prefix);
                sb.append(".");
            }
            sb.append(this.props[i].getName());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String getAssocOneIdExpr(String prefix, String operator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.props.length; ++i) {
            if (i > 0) {
                sb.append(" and ");
            }
            if (prefix != null) {
                sb.append(prefix);
                sb.append(".");
            }
            sb.append(this.props[i].getName());
            sb.append(" ").append(operator);
            sb.append(" ? ");
        }
        return sb.toString();
    }

    @Override
    public String getBindIdSql(String baseTableAlias) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.props.length; ++i) {
            if (i > 0) {
                sb.append(" and ");
            }
            if (baseTableAlias != null) {
                sb.append(baseTableAlias);
                sb.append(".");
            }
            sb.append(this.props[i].getDbColumn());
            sb.append(" = ? ");
        }
        return sb.toString();
    }

    @Override
    public String getBindIdInSql(String baseTableAlias) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < this.props.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(baseTableAlias);
            sb.append(".");
            sb.append(this.props[i].getDbColumn());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public Object convertSetId(Object idValue, Object bean) {
        if (bean != null) {
            this.embIdProperty.setValueIntercept(bean, idValue);
        }
        return idValue;
    }
}

