/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy.meta;

import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptorMap;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyCompoundRoot;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyCompoundScalar;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanEmbedded;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import com.avaje.ebeaninternal.server.type.CtCompoundProperty;
import com.avaje.ebeaninternal.server.type.CtCompoundType;
import com.avaje.ebeaninternal.server.type.CtCompoundTypeScalarList;
import com.avaje.ebeaninternal.server.type.ScalarType;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployBeanPropertyCompound
extends DeployBeanProperty {
    CtCompoundType<?> compoundType;
    DeployBeanEmbedded deployEmbedded;

    public DeployBeanPropertyCompound(DeployBeanDescriptor<?> desc, Class<?> targetType, CtCompoundType<?> compoundType) {
        super(desc, targetType, null);
        this.compoundType = compoundType;
    }

    public BeanPropertyCompoundRoot getFlatProperties(BeanDescriptorMap owner, BeanDescriptor<?> descriptor) {
        BeanPropertyCompoundRoot rootProperty = new BeanPropertyCompoundRoot(this);
        CtCompoundTypeScalarList ctMeta = new CtCompoundTypeScalarList();
        this.compoundType.accumulateScalarTypes(null, ctMeta);
        ArrayList<BeanPropertyCompoundScalar> beanPropertyList = new ArrayList<BeanPropertyCompoundScalar>();
        for (Map.Entry<String, ScalarType<?>> entry : ctMeta.entries()) {
            String relativePropertyName = entry.getKey();
            ScalarType<?> scalarType = entry.getValue();
            CtCompoundProperty ctProp = ctMeta.getCompoundType(relativePropertyName);
            String dbColumn = relativePropertyName.replace(".", "_");
            dbColumn = this.getDbColumn(relativePropertyName, dbColumn);
            DeployBeanProperty deploy = new DeployBeanProperty(null, scalarType.getType(), scalarType);
            deploy.setScalarType(scalarType);
            deploy.setDbColumn(dbColumn);
            deploy.setName(relativePropertyName);
            deploy.setDbInsertable(true);
            deploy.setDbUpdateable(true);
            deploy.setDbRead(true);
            BeanPropertyCompoundScalar bp = new BeanPropertyCompoundScalar(rootProperty, deploy, ctProp);
            beanPropertyList.add(bp);
            rootProperty.register(bp);
        }
        rootProperty.setNonScalarProperties(ctMeta.getNonScalarProperties());
        return rootProperty;
    }

    private String getDbColumn(String propName, String defaultDbColumn) {
        if (this.deployEmbedded == null) {
            return defaultDbColumn;
        }
        String dbColumn = this.deployEmbedded.getPropertyColumnMap().get(propName);
        return dbColumn == null ? defaultDbColumn : dbColumn;
    }

    public DeployBeanEmbedded getDeployEmbedded() {
        if (this.deployEmbedded == null) {
            this.deployEmbedded = new DeployBeanEmbedded();
        }
        return this.deployEmbedded;
    }

    public CtCompoundType<?> getCompoundType() {
        return this.compoundType;
    }

    public void setCompoundType(CtCompoundType<?> compoundType) {
        this.compoundType = compoundType;
    }
}

