/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.lib.cluster;

import com.avaje.ebean.config.GlobalProperties;
import com.avaje.ebeaninternal.server.lib.cluster.Broadcast;
import com.avaje.ebeaninternal.server.lib.cluster.SocketBroadcaster;
import com.avaje.ebeaninternal.server.lib.util.StringHelper;
import com.avaje.ebeaninternal.server.net.ConnectionProcessor;
import com.avaje.ebeaninternal.server.net.Endpoint;
import com.avaje.ebeaninternal.server.net.Headers;
import com.avaje.ebeaninternal.server.net.SocketListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClusterManager {
    private static final Logger logger = Logger.getLogger(ClusterManager.class.getName());
    SocketListener listener;
    Broadcast broadcast;
    Endpoint localMember = null;
    boolean isClusteringOn = false;
    ArrayList<Endpoint> otherMembers = new ArrayList();

    public ClusterManager() {
        String localHostPort = GlobalProperties.get("cluster.local", null);
        if (localHostPort == null) {
            return;
        }
        try {
            String broadcastCn = GlobalProperties.get("cluster.broadcast", null);
            if (broadcastCn != null) {
                Class<?> cls = Class.forName(broadcastCn);
                this.broadcast = (Broadcast)cls.newInstance();
            } else {
                this.broadcast = new SocketBroadcaster();
            }
            this.localMember = new Endpoint(localHostPort);
            String members = GlobalProperties.get("cluster.members", null);
            if (members != null) {
                String[] memArray = StringHelper.delimitedToArray(members, ",", false);
                for (int i = 0; i < memArray.length; ++i) {
                    Endpoint member = new Endpoint(memArray[i]);
                    this.otherMembers.add(member);
                }
                this.otherMembers.remove(this.localMember);
            }
            this.listener = new SocketListener("ClusterListener", this.localMember.getPort());
            this.listener.startListening();
            this.registerProcessor("CLUSTER", this.broadcast);
            this.isClusteringOn = true;
            Endpoint[] others = this.otherMembers.toArray(new Endpoint[this.otherMembers.size()]);
            this.broadcast.register(this.localMember, others);
        }
        catch (Exception ex) {
            String msg = "Clustering has failed to start due to an exception.";
            logger.log(Level.SEVERE, msg, ex);
        }
    }

    public void register(String key, ConnectionProcessor processor) {
        this.registerProcessor(key, processor);
    }

    private void registerProcessor(String key, ConnectionProcessor processor) {
        if (this.listener != null) {
            this.listener.registerRequestHandler(key, processor);
        }
    }

    public boolean isClusteringOn() {
        return this.isClusteringOn;
    }

    public void broadcast(Headers headers, Serializable payload) {
        this.broadcastMessage(headers, payload);
    }

    private void broadcastMessage(Headers headers, Serializable payload) {
        if (this.broadcast != null) {
            this.broadcast.broadcast(headers, payload);
        }
    }

    public void shutdown() {
        if (!this.isClusteringOn) {
            return;
        }
        logger.info("ClusterManager shutdown ");
        if (this.broadcast != null) {
            this.broadcast.deregister();
        }
        this.listener.shutdown();
    }
}

