/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.lib.cluster;

import com.avaje.ebeaninternal.server.lib.cluster.Broadcast;
import com.avaje.ebeaninternal.server.net.Endpoint;
import com.avaje.ebeaninternal.server.net.Headers;
import com.avaje.ebeaninternal.server.net.IoConnection;
import com.avaje.ebeaninternal.server.net.SocketClient;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SocketBroadcaster
extends Broadcast {
    private static final Logger logger = Logger.getLogger(SocketBroadcaster.class.getName());
    boolean sendSecure = false;
    Endpoint local;
    HashMap<String, SocketClient> clientMap = new HashMap();
    SocketClient[] members;

    public void register(Endpoint local, Endpoint[] others) {
        this.local = local;
        Headers h = new Headers();
        h.setProcesorId("CLUSTER");
        h.set("REGISTER", local.getFullName());
        for (int i = 0; i < others.length; ++i) {
            Endpoint member = others[i];
            SocketClient sc = this.create(member);
            boolean isOnline = this.send(sc, h, null, false);
            sc.setOnline(isOnline);
            String msg = "Cluster Member [" + member.getFullName() + "] isOnline[" + isOnline + "]";
            logger.info(msg);
        }
    }

    private SocketClient create(Endpoint endpoint) {
        SocketClient client = new SocketClient();
        client.setEndpoint(endpoint);
        this.clientMap.put(endpoint.getFullName(), client);
        this.members = null;
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMemberOnline(String fullName, boolean isOnline) {
        HashMap<String, SocketClient> hashMap = this.clientMap;
        synchronized (hashMap) {
            String msg = "Cluster Member [" + fullName + "] isOnline[" + isOnline + "]";
            logger.info(msg);
            SocketClient member = this.clientMap.get(fullName);
            member.setOnline(isOnline);
        }
    }

    private boolean send(SocketClient client, Headers headers, Serializable payload, boolean logError) {
        try {
            IoConnection sc = client.createConnection(this.sendSecure);
            sc.writeObject(headers);
            if (payload != null) {
                sc.writeObject(payload);
            }
            sc.getObjectOutputStream().flush();
            sc.disconnect();
            return true;
        }
        catch (Exception ex) {
            if (logError) {
                logger.log(Level.SEVERE, "Error sending message", ex);
            }
            return false;
        }
    }

    private SocketClient[] getMembers() {
        if (this.members == null) {
            Collection<SocketClient> c = this.clientMap.values();
            this.members = c.toArray(new SocketClient[c.size()]);
        }
        return this.members;
    }

    public boolean broadcast(Headers headers, Serializable payload) {
        boolean errors = false;
        SocketClient[] members = this.getMembers();
        for (int i = 0; i < members.length; ++i) {
            if (!members[i].isOnline() || this.send(members[i], headers, payload, true)) continue;
            errors = true;
        }
        return errors;
    }

    public void deregister() {
        Headers h = new Headers();
        h.setProcesorId("CLUSTER");
        h.set("DEREGISTER", this.local.getFullName());
        this.broadcast(h, null);
    }

    public void process(IoConnection request) {
        Headers h = request.getHeaders();
        String regHost = h.get("REGISTER");
        if (regHost != null) {
            this.setMemberOnline(regHost, true);
        }
        if ((regHost = h.get("DEREGISTER")) != null) {
            this.setMemberOnline(regHost, false);
        }
        throw new RuntimeException("Unhandled message type [" + h + "]");
    }
}

