/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.net;

import com.avaje.ebeaninternal.server.net.Authenticate;
import com.avaje.ebeaninternal.server.net.CommandContextManager;
import com.avaje.ebeaninternal.server.net.CommandProcessor;
import com.avaje.ebeaninternal.server.net.CommandSecurity;
import com.avaje.ebeaninternal.server.net.Headers;
import com.avaje.ebeaninternal.server.net.ServletConnection;
import com.avaje.ebeaninternal.server.net.ServletContextManager;
import com.avaje.ebeaninternal.server.net.UtilFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ClientRequestServlet
extends HttpServlet {
    private static final long serialVersionUID = -6030990877455396341L;
    private static final Logger logger = Logger.getLogger(ClientRequestServlet.class.getName());
    private transient CommandProcessor processor;

    public ClientRequestServlet() {
        this.initProcessor();
    }

    private void initProcessor() {
        String dftl = ServletContextManager.class.getName();
        UtilFactory utilFactory = new UtilFactory();
        CommandContextManager cm = utilFactory.createCommandContextManager(dftl);
        CommandSecurity cs = utilFactory.createCommandSecurity(null);
        Authenticate au = utilFactory.createAuthenticate(null);
        this.processor = new CommandProcessor();
        this.processor.setUseSessionId(true);
        this.processor.setContextManager(cm);
        this.processor.setCommandSecurity(cs);
        this.processor.setAuthenticate(au);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            HttpSession session = request.getSession(true);
            String httpSessionId = session.getId();
            ServletConnection conn = new ServletConnection(request, response);
            ObjectInputStream ois = conn.getObjectInputStream();
            Headers headers = (Headers)ois.readObject();
            headers.set("server.httpsessionid", httpSessionId);
            headers.setSession(session);
            conn.setHeaders(headers);
            this.processor.process(conn);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, null, e);
        }
    }
}

