/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.net;

public class Endpoint {
    String host;
    int port;
    String fullName;
    boolean isOnline = false;

    public Endpoint(String host, int port) {
        this.host = host;
        this.port = port;
        this.fullName = host + ":" + port;
    }

    public Endpoint(String fullName) {
        this.fullName = fullName;
        this.parseFullName(fullName);
    }

    private void parseFullName(String fullName) {
        try {
            int colonPos = fullName.indexOf(":");
            if (colonPos > 0) {
                this.host = fullName.substring(0, colonPos);
                String sPort = fullName.substring(colonPos + 1, fullName.length());
                this.port = Integer.parseInt(sPort);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Error parsing [" + fullName + "] for the form [host:port]", ex);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Endpoint) {
            Endpoint nd = (Endpoint)obj;
            return nd.hashCode() == this.hashCode();
        }
        return false;
    }

    public int hashCode() {
        int hc = Endpoint.class.getName().hashCode();
        hc = 31 * hc + this.fullName.hashCode();
        return hc;
    }

    public String toString() {
        return this.fullName;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getFullName() {
        return this.fullName;
    }

    public boolean isOnline() {
        return this.isOnline;
    }

    public void setOnline(boolean isOnline) {
        this.isOnline = isOnline;
    }
}

