/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.net;

import com.avaje.ebean.config.GlobalProperties;
import com.avaje.ebeaninternal.server.net.HttpConnection;
import com.avaje.ebeaninternal.server.net.HttpCookieList;
import com.avaje.ebeaninternal.server.net.IoConnection;
import com.avaje.ebeaninternal.server.net.IoConnectionFactory;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;

public class HttpClient
implements IoConnectionFactory {
    private static final Logger logger = Logger.getLogger(HttpClient.class.getName());
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    protected String host = "127.0.0.1";
    protected int port = 80;
    protected int securePort = 443;
    protected String url = "/app/jcr/client";
    protected HttpCookieList cookieList = new HttpCookieList();

    public HttpClient() {
        this.initialiseHostNameVerifier();
    }

    public void initialiseHostNameVerifier() {
        HostnameVerifier verifier = new NoHostnameVerify();
        String hnv = GlobalProperties.get("avaje.httpclient.hostnameverifier", null);
        if (hnv != null) {
            try {
                Class<?> clz = Class.forName(hnv);
                verifier = (HostnameVerifier)clz.newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        HttpsURLConnection.setDefaultHostnameVerifier(verifier);
    }

    public IoConnection createConnection(boolean secure) throws IOException {
        URLConnection urlConn = this.createURLConnection(secure, -1);
        HttpConnection httpConn = new HttpConnection(urlConn, this.cookieList);
        return httpConn;
    }

    protected URLConnection createURLConnection(boolean secure, int contentLength) throws IOException {
        URL dataURL = null;
        dataURL = secure ? new URL(HTTPS, this.host, this.securePort, this.url) : new URL(HTTP, this.host, this.port, this.url);
        URLConnection connection = dataURL.openConnection();
        connection.setUseCaches(false);
        connection.setDoOutput(true);
        if (contentLength > 0) {
            connection.setRequestProperty("Content-Length", "" + contentLength);
        }
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        return connection;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int httpPort) {
        this.port = httpPort;
    }

    public int getSecurePort() {
        return this.securePort;
    }

    public void setSecurePort(int httpsPort) {
        this.securePort = httpsPort;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    static class NoHostnameVerify
    implements HostnameVerifier {
        NoHostnameVerify() {
        }

        public boolean verify(String urlHostName, SSLSession session) {
            String ph = session.getPeerHost();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("HostnameVerifier.verify() " + urlHostName + ":" + ph);
            }
            return true;
        }
    }
}

