/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.net;

import com.avaje.ebeaninternal.server.net.ConnectionProcessor;
import com.avaje.ebeaninternal.server.net.Headers;
import com.avaje.ebeaninternal.server.net.SocketConnection;
import com.avaje.ebeaninternal.server.net.SocketListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SocketDispatcher
implements Runnable {
    private static final Logger logger = Logger.getLogger(SocketDispatcher.class.getName());
    private Socket clientSocket;
    private SocketListener listener;

    public SocketDispatcher(SocketListener listener, Socket clientSocket) {
        this.clientSocket = clientSocket;
        this.listener = listener;
    }

    protected Headers readHeaders(SocketConnection request) throws Exception {
        ObjectInputStream ois = request.getObjectInputStream();
        return (Headers)ois.readObject();
    }

    public void run() {
        try {
            try {
                SocketConnection request = new SocketConnection(this.clientSocket);
                Headers headers = this.readHeaders(request);
                request.setHeaders(headers);
                String processorId = headers.getProcessorId();
                ConnectionProcessor reqHandler = this.listener.getRequestProcessor(processorId);
                reqHandler.process(request);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error handling message", e);
                Headers response = new Headers();
                response.setThrowable(e);
                OutputStream os = this.clientSocket.getOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(os);
                oos.writeObject(response);
                os.flush();
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, null, e);
        }
    }
}

