/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebean.BackgroundExecutor;
import com.avaje.ebean.Query;
import com.avaje.ebean.config.GlobalProperties;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.config.dbplatform.SqlLimitResponse;
import com.avaje.ebean.config.dbplatform.SqlLimiter;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.core.OrmQueryRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.persist.Binder;
import com.avaje.ebeaninternal.server.query.CQuery;
import com.avaje.ebeaninternal.server.query.CQueryFetchIds;
import com.avaje.ebeaninternal.server.query.CQueryPlan;
import com.avaje.ebeaninternal.server.query.CQueryPredicates;
import com.avaje.ebeaninternal.server.query.CQueryRowCount;
import com.avaje.ebeaninternal.server.query.Constants;
import com.avaje.ebeaninternal.server.query.RawSqlSelectClauseBuilder;
import com.avaje.ebeaninternal.server.query.SqlTree;
import com.avaje.ebeaninternal.server.query.SqlTreeBuilder;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryLimitRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CQueryBuilder
implements Constants {
    private final String tableAliasPlaceHolder;
    private final String columnAliasPrefix;
    private final SqlLimiter sqlLimiter;
    private final RawSqlSelectClauseBuilder rawSqlBuilder;
    private final Binder binder;
    private final BackgroundExecutor backgroundExecutor;

    public CQueryBuilder(BackgroundExecutor backgroundExecutor, DatabasePlatform dbPlatform, Binder binder) {
        this.backgroundExecutor = backgroundExecutor;
        this.binder = binder;
        this.tableAliasPlaceHolder = GlobalProperties.get("ebean.tableAliasPlaceHolder", "${ta}");
        this.columnAliasPrefix = GlobalProperties.get("ebean.columnAliasPrefix", "c");
        this.rawSqlBuilder = new RawSqlSelectClauseBuilder(dbPlatform, binder);
        this.sqlLimiter = dbPlatform.getSqlLimiter();
    }

    protected String getOrderBy(String orderBy, BeanPropertyAssocMany<?> many, BeanDescriptor<?> desc, boolean hasListener) {
        String manyOrderBy = null;
        if (many != null && (manyOrderBy = many.getFetchOrderBy()) != null) {
            manyOrderBy = CQueryBuilder.prefixOrderByFields(many.getName(), manyOrderBy);
        }
        if (orderBy == null && (hasListener || manyOrderBy != null)) {
            StringBuffer sb = new StringBuffer();
            BeanProperty[] uids = desc.propertiesId();
            for (int i = 0; i < uids.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(uids[i].getName());
            }
            orderBy = sb.toString();
        }
        if (manyOrderBy != null) {
            orderBy = orderBy + " , " + manyOrderBy;
        }
        return orderBy;
    }

    public static String prefixOrderByFields(String name, String orderBy) {
        StringBuilder sb = new StringBuilder();
        for (String token : orderBy.split(",")) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(name);
            sb.append(".");
            sb.append(token.trim());
        }
        return sb.toString();
    }

    public <T> CQueryFetchIds buildFetchIdsQuery(OrmQueryRequest<T> request) {
        Query query = request.getQuery();
        query.setSelectId();
        CQueryPredicates predicates = new CQueryPredicates(this.binder, request);
        CQueryPlan queryPlan = request.getQueryPlan();
        if (queryPlan != null) {
            predicates.prepare(false);
            String sql = queryPlan.getSql();
            return new CQueryFetchIds(request, predicates, sql, this.backgroundExecutor);
        }
        predicates.prepare(true);
        SqlTree sqlTree = this.createSqlTree(request, predicates);
        SqlLimitResponse s = this.buildSql(null, request, predicates, sqlTree);
        String sql = s.getSql();
        queryPlan = new CQueryPlan(sql, sqlTree, false, s.isIncludesRowNumberColumn(), predicates.getLogWhereSql());
        request.putQueryPlan(queryPlan);
        return new CQueryFetchIds(request, predicates, sql, this.backgroundExecutor);
    }

    public <T> CQueryRowCount buildRowCountQuery(OrmQueryRequest<T> request) {
        Query query = request.getQuery();
        query.setOrder(null);
        boolean hasMany = !query.getManyWhereJoins().isEmpty();
        query.setSelectId();
        String sqlSelect = "select count(*)";
        if (hasMany) {
            query.setDistinct(true);
            sqlSelect = null;
        }
        CQueryPredicates predicates = new CQueryPredicates(this.binder, request);
        CQueryPlan queryPlan = request.getQueryPlan();
        if (queryPlan != null) {
            predicates.prepare(false);
            String sql = queryPlan.getSql();
            return new CQueryRowCount(request, predicates, sql);
        }
        predicates.prepare(true);
        SqlTree sqlTree = this.createSqlTree(request, predicates);
        SqlLimitResponse s = this.buildSql(sqlSelect, request, predicates, sqlTree);
        String sql = s.getSql();
        if (hasMany) {
            sql = "select count(*) from ( " + sql + ")";
        }
        queryPlan = new CQueryPlan(sql, sqlTree, false, s.isIncludesRowNumberColumn(), predicates.getLogWhereSql());
        request.putQueryPlan(queryPlan);
        return new CQueryRowCount(request, predicates, sql);
    }

    public <T> CQuery<T> buildQuery(OrmQueryRequest<T> request) {
        if (request.isSqlSelect()) {
            return this.rawSqlBuilder.build(request);
        }
        CQueryPredicates predicates = new CQueryPredicates(this.binder, request);
        CQueryPlan queryPlan = request.getQueryPlan();
        if (queryPlan != null) {
            predicates.prepare(false);
            return new CQuery<T>(request, predicates, queryPlan);
        }
        predicates.prepare(true);
        SqlTree sqlTree = this.createSqlTree(request, predicates);
        SqlLimitResponse s = this.buildSql(null, request, predicates, sqlTree);
        queryPlan = new CQueryPlan(request, s.getSql(), sqlTree, false, s.isIncludesRowNumberColumn(), predicates.getLogWhereSql());
        request.putQueryPlan(queryPlan);
        return new CQuery<T>(request, predicates, queryPlan);
    }

    private SqlTree createSqlTree(OrmQueryRequest<?> request, CQueryPredicates predicates) {
        return new SqlTreeBuilder(this.tableAliasPlaceHolder, this.columnAliasPrefix, request, predicates).build();
    }

    private SqlLimitResponse buildSql(String selectClause, OrmQueryRequest<?> request, CQueryPredicates predicates, SqlTree select) {
        String dbOrderBy;
        String dbFilterMany;
        String dbWhere;
        Query query = request.getQuery();
        BeanPropertyAssocMany<?> manyProp = select.getManyProperty();
        boolean useSqlLimiter = false;
        StringBuilder sb = new StringBuilder(500);
        if (selectClause != null) {
            sb.append(selectClause);
        } else {
            boolean bl = useSqlLimiter = query.hasMaxRowsOrFirstRow() && manyProp == null;
            if (!useSqlLimiter) {
                sb.append("select ");
                if (query.isDistinct()) {
                    sb.append("distinct ");
                }
            }
            sb.append(select.getSelectSql());
        }
        sb.append(" ").append('\n');
        sb.append("from ");
        sb.append(select.getFromSql());
        String inheritanceWhere = select.getInheritanceWhereSql();
        boolean hasWhere = false;
        if (inheritanceWhere.length() > 0) {
            sb.append(" ").append('\n').append("where");
            sb.append(inheritanceWhere);
            hasWhere = true;
        }
        if (request.isFindById() || query.getId() != null) {
            if (hasWhere) {
                sb.append(" and ");
            } else {
                sb.append('\n').append("where ");
            }
            BeanDescriptor<?> desc = request.getBeanDescriptor();
            String idSql = desc.getIdBinderIdSql();
            sb.append(idSql).append(" ");
            hasWhere = true;
        }
        if (!this.isEmpty(dbWhere = predicates.getDbWhere())) {
            if (!hasWhere) {
                hasWhere = true;
                sb.append(" ").append('\n').append("where ");
            } else {
                sb.append("and ");
            }
            sb.append(dbWhere);
        }
        if (!this.isEmpty(dbFilterMany = predicates.getDbFilterMany())) {
            if (!hasWhere) {
                sb.append(" ").append('\n').append("where ");
            } else {
                sb.append("and ");
            }
            sb.append(dbFilterMany);
        }
        if ((dbOrderBy = predicates.getDbOrderBy()) != null) {
            sb.append(" ").append('\n');
            sb.append("order by ").append(dbOrderBy);
        }
        if (useSqlLimiter) {
            OrmQueryLimitRequest r = new OrmQueryLimitRequest(sb.toString(), dbOrderBy, (SpiQuery<?>)query);
            return this.sqlLimiter.limit(r);
        }
        return new SqlLimitResponse(sb.toString(), false);
    }

    private boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }
}

