/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebean.BackgroundExecutor;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.BeanCollectionTouched;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebeaninternal.api.BeanIdList;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.core.Message;
import com.avaje.ebeaninternal.server.core.OrmQueryRequest;
import com.avaje.ebeaninternal.server.jmx.MAdminLogging;
import com.avaje.ebeaninternal.server.persist.Binder;
import com.avaje.ebeaninternal.server.query.BackgroundFetch;
import com.avaje.ebeaninternal.server.query.CQuery;
import com.avaje.ebeaninternal.server.query.CQueryBuilder;
import com.avaje.ebeaninternal.server.query.CQueryFetchIds;
import com.avaje.ebeaninternal.server.query.CQueryRowCount;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.logging.Logger;
import javax.persistence.PersistenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CQueryEngine {
    private static final Logger logger = Logger.getLogger(CQueryEngine.class.getName());
    private final CQueryBuilder queryBuilder;
    private final MAdminLogging logControl;
    private final BackgroundExecutor backgroundExecutor;
    private final int defaultSecondaryQueryBatchSize = 100;

    public CQueryEngine(DatabasePlatform dbPlatform, MAdminLogging logControl, Binder binder, BackgroundExecutor backgroundExecutor) {
        this.logControl = logControl;
        this.backgroundExecutor = backgroundExecutor;
        this.queryBuilder = new CQueryBuilder(backgroundExecutor, dbPlatform, binder);
    }

    public <T> CQuery<T> buildQuery(OrmQueryRequest<T> request) {
        return this.queryBuilder.buildQuery(request);
    }

    public <T> BeanIdList findIds(OrmQueryRequest<T> request) {
        CQueryFetchIds rcQuery = this.queryBuilder.buildFetchIdsQuery(request);
        try {
            String sql = rcQuery.getGeneratedSql();
            sql = sql.replace('\n', ' ');
            if (this.logControl.isDebugGeneratedSql()) {
                System.out.println(sql);
            }
            if (this.logControl.isLogQuery(MAdminLogging.SQL)) {
                request.getTransaction().log(sql);
            }
            BeanIdList list = rcQuery.findIds();
            if (this.logControl.isLogQuery(MAdminLogging.SUMMARY)) {
                request.getTransaction().log(rcQuery.getSummary());
            }
            if (!list.isFetchingInBackground() && request.getQuery().isFutureFetch()) {
                logger.fine("Future findIds completed!");
                request.getTransaction().end();
            }
            return list;
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public <T> int findRowCount(OrmQueryRequest<T> request) {
        CQueryRowCount rcQuery = this.queryBuilder.buildRowCountQuery(request);
        try {
            String sql = rcQuery.getGeneratedSql();
            sql = sql.replace('\n', ' ');
            if (this.logControl.isDebugGeneratedSql()) {
                System.out.println(sql);
            }
            if (this.logControl.isLogQuery(MAdminLogging.SQL)) {
                request.getTransaction().log(sql);
            }
            int rowCount = rcQuery.findRowCount();
            if (this.logControl.isLogQuery(MAdminLogging.SUMMARY)) {
                request.getTransaction().log(rcQuery.getSummary());
            }
            if (request.getQuery().isFutureFetch()) {
                logger.fine("Future findRowCount completed!");
                request.getTransaction().end();
            }
            return rowCount;
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public <T> BeanCollection<T> findMany(OrmQueryRequest<T> request) {
        boolean useBackgroundToContinueFetch = false;
        CQuery<T> cquery = this.queryBuilder.buildQuery(request);
        request.setCancelableQuery(cquery);
        try {
            Object fetch;
            BeanCollectionTouched collectionTouched;
            if (this.logControl.isDebugGeneratedSql()) {
                this.logSqlToConsole(cquery);
            }
            if (this.logControl.isLogQuery(MAdminLogging.SQL)) {
                this.logSql(cquery);
            }
            if (!cquery.prepareBindExecuteQuery()) {
                logger.finest("Future fetch already cancelled");
                BeanCollection<T> beanCollection = null;
                return beanCollection;
            }
            BeanCollection<T> beanCollection = cquery.readCollection();
            if (request.getParentState() != 0) {
                beanCollection.setSharedInstance();
            }
            if ((collectionTouched = request.getQuery().getBeanCollectionTouched()) != null) {
                beanCollection.setBeanCollectionTouched(collectionTouched);
            }
            if (cquery.useBackgroundToContinueFetch()) {
                request.setBackgroundFetching();
                useBackgroundToContinueFetch = true;
                fetch = new BackgroundFetch(cquery);
                FutureTask<Integer> future = new FutureTask<Integer>((Callable<Integer>)fetch);
                beanCollection.setBackgroundFetch(future);
                this.backgroundExecutor.execute(future);
            }
            if (this.logControl.isLogQuery(MAdminLogging.SUMMARY)) {
                this.logFindManySummary(cquery);
            }
            request.executeSecondaryQueries(100);
            fetch = beanCollection;
            return fetch;
        }
        catch (SQLException e) {
            String sql = cquery.getGeneratedSql();
            String m = Message.msg("fetch.error", e.getMessage(), sql);
            throw new PersistenceException(m, (Throwable)e);
        }
        finally {
            if (!useBackgroundToContinueFetch) {
                if (cquery != null) {
                    cquery.close();
                }
                if (request.getQuery().isFutureFetch()) {
                    logger.fine("Future fetch completed!");
                    request.getTransaction().end();
                }
            }
        }
    }

    public <T> T find(OrmQueryRequest<T> request) {
        T bean = null;
        CQuery<T> cquery = this.queryBuilder.buildQuery(request);
        try {
            if (this.logControl.isDebugGeneratedSql()) {
                this.logSqlToConsole(cquery);
            }
            if (this.logControl.isLogQuery(MAdminLogging.SQL)) {
                this.logSql(cquery);
            }
            cquery.prepareBindExecuteQuery();
            if (cquery.readBean()) {
                bean = cquery.getLoadedBean();
            }
            if (this.logControl.isLogQuery(MAdminLogging.SUMMARY)) {
                this.logFindSummary(cquery);
            }
            request.executeSecondaryQueries(100);
            T t = bean;
            return t;
        }
        catch (SQLException e) {
            String sql = cquery.getGeneratedSql();
            String msg = Message.msg("fetch.error", e.getMessage(), sql);
            throw new PersistenceException(msg, (Throwable)e);
        }
        finally {
            cquery.close();
        }
    }

    private void logSqlToConsole(CQuery<?> cquery) {
        SpiQuery<?> query = cquery.getQueryRequest().getQuery();
        String loadMode = query.getLoadMode();
        String loadDesc = query.getLoadDescription();
        String sql = cquery.getGeneratedSql();
        String summary = cquery.getSummary();
        StringBuilder sb = new StringBuilder(1000);
        sb.append("<sql ");
        if (query.isAutofetchTuned()) {
            sb.append("tuned='true' ");
        }
        if (loadMode != null) {
            sb.append("mode='").append(loadMode).append("' ");
        }
        sb.append("summary='").append(summary);
        if (loadDesc != null) {
            sb.append("' load='").append(loadDesc);
        }
        sb.append("' >");
        sb.append('\n');
        sb.append(sql);
        sb.append('\n').append("</sql>");
        System.out.println(sb.toString());
    }

    private void logSql(CQuery<?> query) {
        String sql = query.getGeneratedSql();
        sql = sql.replace('\n', ' ');
        query.getTransaction().log(sql);
    }

    private void logFindSummary(CQuery<?> q) {
        StringBuilder msg = new StringBuilder(200);
        msg.append("FindById exeMicros[").append("" + q.getQueryExecutionTimeMicros());
        msg.append("] rows[").append(q.getLoadedRowDetail());
        msg.append("] type[").append(q.getBeanName());
        msg.append("] bind[").append(q.getBindLog()).append("]");
        q.getTransaction().log(msg.toString());
    }

    private void logFindManySummary(CQuery<?> q) {
        StringBuilder msg = new StringBuilder(200);
        msg.append("FindMany exeMicros[").append(q.getQueryExecutionTimeMicros());
        msg.append("] rows[").append(q.getLoadedRowDetail());
        msg.append("] type[").append(q.getBeanName());
        msg.append("] name[").append(q.getName());
        msg.append("] predicates[").append(q.getLogWhereSql());
        msg.append("] bind[").append(q.getBindLog()).append("]");
        q.getTransaction().log(msg.toString());
    }
}

