/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebeaninternal.server.deploy.parse.SqlReservedWords;
import com.avaje.ebeaninternal.server.query.SplitName;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlTreeAlias {
    private static final String alphabet = "abcdefghijklmnopqrstuvwxy";
    private TreeSet<String> joinProps = new TreeSet();
    private TreeSet<String> manyWhereJoinProps = new TreeSet();
    private HashMap<String, String> aliasMap = new HashMap();
    private HashMap<String, String> manyWhereAliasMap = new HashMap();
    private final String rootTableAlias;

    public SqlTreeAlias(String rootTableAlias) {
        this.rootTableAlias = rootTableAlias;
    }

    public void addManyWhereJoins(Set<String> manyWhereJoins) {
        if (manyWhereJoins != null) {
            for (String include : manyWhereJoins) {
                this.addPropertyJoin(include, this.manyWhereJoinProps);
            }
        }
    }

    public void addJoin(Set<String> propJoins) {
        if (propJoins != null) {
            for (String propJoin : propJoins) {
                this.addPropertyJoin(propJoin, this.joinProps);
            }
        }
    }

    private void addPropertyJoin(String include, TreeSet<String> set) {
        set.add(include);
        String[] split = SplitName.split(include);
        if (split[0] != null) {
            this.addPropertyJoin(split[0], set);
        }
    }

    public void buildAlias() {
        Iterator<String> i = this.joinProps.iterator();
        while (i.hasNext()) {
            this.calcAlias(i.next());
        }
        i = this.manyWhereJoinProps.iterator();
        while (i.hasNext()) {
            this.calcAliasManyWhere(i.next());
        }
    }

    private String calcAlias(String prefix) {
        String[] split = SplitName.split(prefix);
        String attempt = this.parentAlias(split[0]) + split[1].charAt(0);
        String alias = this.nextAlias(attempt);
        this.aliasMap.put(prefix, alias);
        return alias;
    }

    private String calcAliasManyWhere(String prefix) {
        String[] split = SplitName.split(prefix);
        String attempt = "x" + split[1].charAt(0);
        String alias = this.nextAlias(attempt);
        this.manyWhereAliasMap.put(prefix, alias);
        return alias;
    }

    private String parentAlias(String s) {
        if (s == null) {
            return this.rootTableAlias;
        }
        return this.aliasMap.get(s);
    }

    public String getTableAlias(String prefix) {
        if (prefix == null) {
            return this.rootTableAlias;
        }
        String s = this.aliasMap.get(prefix);
        if (s == null) {
            return this.calcAlias(prefix);
        }
        return s;
    }

    public String getTableAliasManyWhere(String prefix) {
        if (prefix == null) {
            return this.rootTableAlias;
        }
        String s = this.manyWhereAliasMap.get(prefix);
        if (s == null) {
            s = this.aliasMap.get(prefix);
        }
        if (s == null) {
            String msg = "Could not determine table alias for [" + prefix + "] manyMap[" + this.manyWhereAliasMap + "] aliasMap[" + this.aliasMap + "]";
            throw new RuntimeException(msg);
        }
        return s;
    }

    public String parseWhere(String clause) {
        clause = this.parseRootAlias(clause);
        clause = this.parseAliasMap(clause, this.manyWhereAliasMap);
        return this.parseAliasMap(clause, this.aliasMap);
    }

    public String parse(String clause) {
        clause = this.parseRootAlias(clause);
        return this.parseAliasMap(clause, this.aliasMap);
    }

    private String parseRootAlias(String clause) {
        if (this.rootTableAlias == null) {
            return clause.replace("${}", "");
        }
        return clause.replace("${}", this.rootTableAlias + ".");
    }

    private String parseAliasMap(String clause, HashMap<String, String> parseAliasMap) {
        for (Map.Entry<String, String> e : parseAliasMap.entrySet()) {
            String k = "${" + e.getKey() + "}";
            clause = clause.replace(k, e.getValue() + ".");
        }
        return clause;
    }

    private String nextAlias(String prefAlias) {
        if (this.validAlias(prefAlias)) {
            return prefAlias;
        }
        String prefix = prefAlias.length() > 1 ? prefAlias.substring(0, prefAlias.length() - 1) : "";
        for (int i = 0; i < 26; ++i) {
            String test = prefix + alphabet.charAt(i);
            if (!this.validAlias(test)) continue;
            return test;
        }
        return this.nextAlias(prefAlias + "z");
    }

    private boolean validAlias(String alias) {
        return !SqlReservedWords.isKeyword(alias) && !this.aliasMap.containsValue(alias);
    }
}

