/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.querydefn;

import com.avaje.ebean.JoinConfig;
import com.avaje.ebean.Query;
import com.avaje.ebean.event.BeanQueryRequest;
import com.avaje.ebeaninternal.api.SpiExpressionList;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.core.ReferenceOptions;
import com.avaje.ebeaninternal.server.expression.DefaultExpressionFactory;
import com.avaje.ebeaninternal.server.lib.util.StringHelper;
import com.avaje.ebeaninternal.server.query.SplitName;
import com.avaje.ebeaninternal.util.FilterExpressionList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmQueryProperties
implements Serializable {
    private static final long serialVersionUID = -8785582703966455658L;
    private String parentPath;
    private String path;
    private String properties;
    private String trimmedProperties;
    private int queryJoinBatch = -1;
    private int lazyJoinBatch = -1;
    private boolean cache;
    private boolean readOnly;
    private boolean allProperties;
    private Set<String> included;
    private Set<String> includedBeanJoin;
    private Set<String> secondaryQueryJoins;
    private List<OrmQueryProperties> secondaryChildren;
    private SpiExpressionList filterMany;

    public OrmQueryProperties() {
        this(null, null, null);
    }

    public OrmQueryProperties(String path, String properties, JoinConfig joinConfig) {
        this.path = path;
        this.parentPath = SplitName.parent(path);
        this.properties = properties;
        this.trimmedProperties = properties;
        this.parseProperties();
        if (joinConfig != null) {
            this.lazyJoinBatch = joinConfig.getLazyBatchSize();
            this.queryJoinBatch = joinConfig.getQueryBatchSize();
        }
        this.allProperties = this.isAllProperties();
        this.included = !this.allProperties ? OrmQueryProperties.parseIncluded(this.trimmedProperties) : null;
    }

    private boolean isAllProperties() {
        return this.trimmedProperties == null || this.trimmedProperties.length() == 0 || "*".equals(this.trimmedProperties);
    }

    public <T> SpiExpressionList<T> filterMany(Query<T> rootQuery) {
        if (this.filterMany == null) {
            DefaultExpressionFactory expr = new DefaultExpressionFactory(this.path);
            this.filterMany = new FilterExpressionList<T>(expr, rootQuery);
        }
        return this.filterMany;
    }

    public SpiExpressionList<?> getFilterMany() {
        return this.filterMany;
    }

    public void setFilterMany(SpiExpressionList<?> filterMany) {
        this.filterMany = filterMany;
    }

    public void setProperties(String properties, Set<String> included) {
        this.properties = properties;
        this.trimmedProperties = properties;
        this.included = included;
        this.allProperties = false;
    }

    public void setTunedProperties(OrmQueryProperties tunedProperties) {
        this.properties = tunedProperties.properties;
        this.trimmedProperties = tunedProperties.trimmedProperties;
        this.included = tunedProperties.included;
        this.allProperties = tunedProperties.allProperties;
    }

    public void configureBeanQuery(SpiQuery<?> query) {
        if (this.trimmedProperties != null && this.trimmedProperties.length() > 0) {
            query.select(this.trimmedProperties);
            if (this.filterMany != null) {
                query.setFilterMany(this.path, this.filterMany);
            }
        }
        if (this.secondaryChildren != null) {
            int trimPath = this.path.length() + 1;
            for (int i = 0; i < this.secondaryChildren.size(); ++i) {
                OrmQueryProperties p = this.secondaryChildren.get(i);
                String path = p.getPath();
                path = path.substring(trimPath);
                query.join(path, p.getProperties());
                query.setFilterMany(path, p.getFilterMany());
            }
        }
    }

    public void configureManyQuery(SpiQuery<?> query) {
        if (this.trimmedProperties != null && this.trimmedProperties.length() > 0) {
            query.join(query.getLazyLoadManyPath(), this.trimmedProperties);
        }
        if (this.filterMany != null) {
            query.setFilterMany(this.path, this.filterMany);
        }
        if (this.secondaryChildren != null) {
            int trimlen = this.path.length() - query.getLazyLoadManyPath().length();
            for (int i = 0; i < this.secondaryChildren.size(); ++i) {
                OrmQueryProperties p = this.secondaryChildren.get(i);
                String path = p.getPath();
                path = path.substring(trimlen);
                query.join(path, p.getProperties());
                query.setFilterMany(path, p.getFilterMany());
            }
        }
    }

    public OrmQueryProperties copy() {
        OrmQueryProperties copy = new OrmQueryProperties();
        copy.parentPath = this.parentPath;
        copy.path = this.path;
        copy.properties = this.properties;
        copy.cache = this.cache;
        copy.readOnly = this.readOnly;
        copy.queryJoinBatch = this.queryJoinBatch;
        copy.lazyJoinBatch = this.lazyJoinBatch;
        copy.allProperties = this.allProperties;
        copy.filterMany = this.filterMany;
        if (this.included != null) {
            copy.included = new HashSet<String>(this.included);
        }
        if (this.includedBeanJoin != null) {
            copy.includedBeanJoin = new HashSet<String>(this.includedBeanJoin);
        }
        return copy;
    }

    public boolean hasSelectClause() {
        if ("*".equals(this.trimmedProperties)) {
            return true;
        }
        return this.included != null;
    }

    public String toString() {
        String s = "";
        if (this.path != null) {
            s = s + this.path + " ";
        }
        if (this.properties != null) {
            s = s + "(" + this.properties + ") ";
        }
        return s;
    }

    public boolean isChild(OrmQueryProperties possibleChild) {
        return possibleChild.getPath().startsWith(this.path + ".");
    }

    public void add(OrmQueryProperties child) {
        if (this.secondaryChildren == null) {
            this.secondaryChildren = new ArrayList<OrmQueryProperties>();
        }
        this.secondaryChildren.add(child);
    }

    public int autofetchPlanHash() {
        int hc = this.path != null ? this.path.hashCode() : 1;
        hc = hc * 31 + (this.properties != null ? this.properties.hashCode() : 1);
        return hc;
    }

    public int queryPlanHash(BeanQueryRequest<?> request) {
        int hc = this.path != null ? this.path.hashCode() : 1;
        hc = hc * 31 + (this.properties != null ? this.properties.hashCode() : 1);
        hc = hc * 31 + (this.filterMany != null ? this.filterMany.queryPlanHash(request) : 1);
        return hc;
    }

    public String getProperties() {
        return this.properties;
    }

    public ReferenceOptions getReferenceOptions() {
        if (this.cache || this.readOnly) {
            return new ReferenceOptions(this.cache, this.readOnly, null);
        }
        return null;
    }

    public boolean isFetchInclude() {
        if (this.cache) {
            return false;
        }
        return this.allProperties || this.included != null && !this.included.isEmpty();
    }

    public boolean hasProperties() {
        return this.properties != null;
    }

    public boolean isIncludedBeanJoin(String propertyName) {
        if (this.includedBeanJoin == null) {
            return false;
        }
        return this.includedBeanJoin.contains(propertyName);
    }

    public void includeBeanJoin(String propertyName) {
        if (this.includedBeanJoin == null) {
            this.includedBeanJoin = new HashSet<String>();
        }
        this.includedBeanJoin.add(propertyName);
    }

    public boolean allProperties() {
        return this.allProperties;
    }

    public Iterator<String> getSelectProperties() {
        if (this.secondaryQueryJoins == null) {
            return this.included.iterator();
        }
        LinkedHashSet<String> temp = new LinkedHashSet<String>(this.secondaryQueryJoins.size() + this.included.size());
        temp.addAll(this.included);
        temp.addAll(this.secondaryQueryJoins);
        return temp.iterator();
    }

    public void addSecondaryQueryJoin(String property) {
        if (this.secondaryQueryJoins == null) {
            this.secondaryQueryJoins = new HashSet<String>(4);
        }
        this.secondaryQueryJoins.add(property);
    }

    public Set<String> getAllIncludedProperties() {
        if (this.included == null) {
            return null;
        }
        if (this.includedBeanJoin == null && this.secondaryQueryJoins == null) {
            return new LinkedHashSet<String>(this.included);
        }
        LinkedHashSet<String> s = new LinkedHashSet<String>(2 * (this.included.size() + 5));
        if (this.included != null) {
            s.addAll(this.included);
        }
        if (this.includedBeanJoin != null) {
            s.addAll(this.includedBeanJoin);
        }
        if (this.secondaryQueryJoins != null) {
            s.addAll(this.secondaryQueryJoins);
        }
        return s;
    }

    public boolean isIncluded(String propName) {
        if (this.includedBeanJoin != null && this.includedBeanJoin.contains(propName)) {
            return false;
        }
        if (this.allProperties) {
            return true;
        }
        return this.included.contains(propName);
    }

    public OrmQueryProperties setQueryJoinBatch(int queryJoinBatch) {
        this.queryJoinBatch = queryJoinBatch;
        return this;
    }

    public OrmQueryProperties setLazyJoinBatch(int lazyJoinBatch) {
        this.lazyJoinBatch = lazyJoinBatch;
        return this;
    }

    public boolean isFetchJoin() {
        return !this.isQueryJoin() && !this.isLazyJoin();
    }

    public boolean isQueryJoin() {
        return this.queryJoinBatch > -1;
    }

    public int getQueryJoinBatch() {
        return this.queryJoinBatch;
    }

    public boolean isLazyJoin() {
        return this.lazyJoinBatch > -1;
    }

    public int getLazyJoinBatch() {
        return this.lazyJoinBatch;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isCache() {
        return this.cache;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public String getPath() {
        return this.path;
    }

    private void parseProperties() {
        if (this.trimmedProperties == null) {
            return;
        }
        int pos = this.trimmedProperties.indexOf("+readonly");
        if (pos > -1) {
            this.trimmedProperties = StringHelper.replaceString(this.trimmedProperties, "+readonly", "");
            this.readOnly = true;
        }
        if ((pos = this.trimmedProperties.indexOf("+cache")) > -1) {
            this.trimmedProperties = StringHelper.replaceString(this.trimmedProperties, "+cache", "");
            this.cache = true;
        }
        if ((pos = this.trimmedProperties.indexOf("+query")) > -1) {
            this.queryJoinBatch = this.parseBatchHint(pos, "+query");
        }
        if ((pos = this.trimmedProperties.indexOf("+lazy")) > -1) {
            this.lazyJoinBatch = this.parseBatchHint(pos, "+lazy");
        }
        this.trimmedProperties = this.trimmedProperties.trim();
        while (this.trimmedProperties.startsWith(",")) {
            this.trimmedProperties = this.trimmedProperties.substring(1).trim();
        }
    }

    private int parseBatchHint(int pos, String option) {
        int startPos = pos + option.length();
        int endPos = this.findEndPos(startPos, this.trimmedProperties);
        if (endPos == -1) {
            this.trimmedProperties = StringHelper.replaceString(this.trimmedProperties, option, "");
            return 0;
        }
        String batchParam = this.trimmedProperties.substring(startPos + 1, endPos);
        this.trimmedProperties = endPos + 1 >= this.trimmedProperties.length() ? this.trimmedProperties.substring(0, pos) : this.trimmedProperties.substring(0, pos) + this.trimmedProperties.substring(endPos + 1);
        return Integer.parseInt(batchParam);
    }

    private int findEndPos(int pos, String props) {
        if (pos < props.length() && props.charAt(pos) == '(') {
            int endPara = props.indexOf(41, pos + 1);
            if (endPara == -1) {
                String m = "Error could not find ')' in " + props + " after position " + pos;
                throw new RuntimeException(m);
            }
            return endPara;
        }
        return -1;
    }

    private static Set<String> parseIncluded(String rawList) {
        String[] res = rawList.split(",");
        LinkedHashSet<String> set = new LinkedHashSet<String>(res.length + 3);
        String temp = null;
        for (int i = 0; i < res.length; ++i) {
            temp = res[i].trim();
            if (temp.length() <= 0) continue;
            set.add(temp);
        }
        return Collections.unmodifiableSet(set);
    }
}

