/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.transaction;

import com.avaje.ebeaninternal.api.TransactionEvent;
import com.avaje.ebeaninternal.api.TransactionEventBeans;
import com.avaje.ebeaninternal.api.TransactionEventTable;
import com.avaje.ebeaninternal.net.Constants;
import com.avaje.ebeaninternal.server.core.PersistRequestBean;
import com.avaje.ebeaninternal.server.lib.cluster.ClusterManager;
import com.avaje.ebeaninternal.server.net.CmdRemoteTransactionEvent;
import com.avaje.ebeaninternal.server.net.Headers;
import com.avaje.ebeaninternal.server.transaction.RemoteBeanPersist;
import com.avaje.ebeaninternal.server.transaction.RemoteTransactionEvent;
import com.avaje.ebeaninternal.server.transaction.TransactionManager;
import java.util.ArrayList;

public final class PostCommitProcessing
implements Runnable,
Constants {
    private final ClusterManager clusterManager;
    private final TransactionEvent event;
    private final String serverName;

    public PostCommitProcessing(ClusterManager clusterManager, TransactionManager manager, TransactionEvent event) {
        this.clusterManager = clusterManager;
        this.serverName = manager.getServerName();
        this.event = event;
    }

    public void run() {
        TransactionEventTable eventTables;
        ArrayList<PersistRequestBean<?>> requests;
        RemoteTransactionEvent remoteEvent = new RemoteTransactionEvent();
        TransactionEventBeans eventBeans = this.event.getEventBeans();
        if (eventBeans != null && (requests = eventBeans.getRequests()) != null) {
            for (int i = 0; i < requests.size(); ++i) {
                RemoteBeanPersist remote = requests.get(i).notifyLocalPersistListener();
                if (remote == null) continue;
                remoteEvent.add(remote);
            }
        }
        if ((eventTables = this.event.getEventTables()) != null && !eventTables.isEmpty()) {
            remoteEvent.setTableEvents(this.event.getEventTables());
        }
        if (remoteEvent.hasEvents()) {
            this.sendEventToCluster(remoteEvent);
        }
    }

    private void sendEventToCluster(RemoteTransactionEvent e) {
        if (this.clusterManager.isClusteringOn()) {
            Headers h = new Headers();
            h.setProcesorId("EBEAN");
            h.set("NAME", this.serverName);
            CmdRemoteTransactionEvent cmd = new CmdRemoteTransactionEvent(e);
            this.clusterManager.broadcast(h, cmd);
        }
    }
}

