/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.transaction;

import com.avaje.ebean.event.BeanPersistListener;
import com.avaje.ebeaninternal.server.core.PersistRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteBeanPersist
implements Serializable {
    static final long serialVersionUID = 8389469180931531408L;
    private final PersistRequest.Type type;
    private final String beanType;
    private final Serializable id;

    public RemoteBeanPersist(String beanType, PersistRequest.Type type, Serializable id) {
        this.beanType = beanType;
        this.type = type;
        this.id = id;
    }

    public PersistRequest.Type getType() {
        return this.type;
    }

    public String getBeanType() {
        return this.beanType;
    }

    public Serializable getId() {
        return this.id;
    }

    public void notifyListener(BeanDescriptor<?> desc) {
        BeanPersistListener<?> listener = desc.getPersistListener();
        if (listener != null) {
            switch (this.type) {
                case INSERT: {
                    listener.remoteInsert(this.id);
                    break;
                }
                case UPDATE: {
                    listener.remoteUpdate(this.id);
                    break;
                }
                case DELETE: {
                    listener.remoteDelete(this.id);
                    break;
                }
            }
        }
    }
}

