/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.transaction;

import com.avaje.ebean.AdminLogging;
import com.avaje.ebean.config.GlobalProperties;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.server.transaction.log.DefaultTransactionLogger;
import com.avaje.ebeaninternal.server.transaction.log.JuliTransactionLogger;
import com.avaje.ebeaninternal.server.transaction.log.LogTime;
import com.avaje.ebeaninternal.server.transaction.log.TransactionLogger;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class TransactionLogManager {
    static final Logger logger = Logger.getLogger(TransactionLogManager.class.getName());
    public static final int LOG_NONE = 0;
    public static final int LOG_EXPLICIT = 1;
    public static final int LOG_ALL = 2;
    public static final int NONE_SHARE_LOGGER = 0;
    public static final int IMPLICIT_SHARE_LOGGER = 1;
    public static final int ALL_SHARE_LOGGER = 2;
    private final String[] logSep = new String[]{"", "_"};
    private final Map<String, TransactionLogger> loggerMap = new ConcurrentHashMap<String, TransactionLogger>(200);
    private final String sharedLogFileName;
    private final String baseDir;
    private final String serverName;
    private AdminLogging.LogLevel logLevel;
    private AdminLogging.LogFileSharing logSharing;
    private final boolean transactionLogToJavaLogger;
    private final TransactionLogger sharedLogger;

    public TransactionLogManager(ServerConfig serverConfig) {
        this.serverName = serverConfig.getName();
        this.sharedLogFileName = GlobalProperties.get("log.filename", "trans");
        this.logLevel = serverConfig.getLoggingLevel();
        this.logSharing = serverConfig.getLoggingLogFileSharing();
        this.transactionLogToJavaLogger = serverConfig.isLoggingToJavaLogger();
        String dir = serverConfig.getLoggingDirectoryWithEval();
        if (dir == null) {
            dir = this.createDefaultLogsDirectory();
        }
        this.baseDir = dir;
        if (this.logLevel == AdminLogging.LogLevel.NONE) {
            String m = "Transaction logging is OFF  ... ebean.log.level=0";
            logger.info(m);
        } else {
            String m = "Transaction logs in: " + this.baseDir;
            logger.info(m);
        }
        this.sharedLogger = this.createSharedLogger();
    }

    private String createDefaultLogsDirectory() {
        String dftlDir = "logs/trans";
        File f = new File(dftlDir);
        if (f.mkdirs()) {
            return dftlDir;
        }
        return "logs";
    }

    public void setLogLevel(AdminLogging.LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public AdminLogging.LogLevel getLogLevel() {
        return this.logLevel;
    }

    public AdminLogging.LogFileSharing getLogSharing() {
        return this.logSharing;
    }

    public void setLogSharing(AdminLogging.LogFileSharing logSharing) {
        this.logSharing = logSharing;
    }

    public void transactionEnded(SpiTransaction t, String msg) {
        TransactionLogger logger = this.removeLogger(t);
        if (logger != null) {
            if (msg != null) {
                msg = "Trans[" + t.getId() + "] " + msg;
                logger.log(t.getId(), msg, null);
            }
            logger.close();
        }
    }

    public void log(SpiTransaction t, String msg, Throwable error) {
        switch (this.logLevel) {
            case NONE: {
                break;
            }
            case ALL: {
                this.logInfo(t, msg, error);
                break;
            }
            case EXPLICIT: {
                if (!t.isExplicit()) break;
                this.logInfo(t, msg, error);
                break;
            }
        }
    }

    private void logInfo(SpiTransaction t, String msg, Throwable error) {
        this.getLogger(t).log(t.getId(), msg, error);
    }

    private TransactionLogger removeLogger(SpiTransaction t) {
        if (this.transactionLogToJavaLogger) {
            return this.sharedLogger;
        }
        String id = t.getId();
        if (id != null) {
            return this.loggerMap.remove(id);
        }
        return null;
    }

    private TransactionLogger getLogger(SpiTransaction t) {
        if (this.transactionLogToJavaLogger) {
            return this.sharedLogger;
        }
        if (this.logSharing == AdminLogging.LogFileSharing.ALL) {
            return this.sharedLogger;
        }
        if (this.logSharing == AdminLogging.LogFileSharing.EXPLICIT && !t.isExplicit()) {
            return this.sharedLogger;
        }
        TransactionLogger logger = this.loggerMap.get(t.getId());
        if (logger == null) {
            logger = this.createLogger(t);
            this.loggerMap.put(t.getId(), logger);
        }
        return logger;
    }

    private TransactionLogger createLogger(SpiTransaction t) {
        if (this.transactionLogToJavaLogger) {
            return this.sharedLogger;
        }
        LogTime logTime = LogTime.getWithCheck();
        String logFileName = this.serverName + "_" + t.getId() + "_" + logTime.getYMD() + "_" + logTime.getNow(this.logSep);
        return new DefaultTransactionLogger(this.baseDir, logFileName, false);
    }

    private TransactionLogger createSharedLogger() {
        if (this.transactionLogToJavaLogger) {
            return new JuliTransactionLogger();
        }
        String logFileName = this.serverName + "_" + this.sharedLogFileName;
        return new DefaultTransactionLogger(this.baseDir, logFileName, true);
    }
}

