/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebeaninternal.server.core.BasicTypeConverter;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.ScalarTypeBase;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalarTypeCalendar
extends ScalarTypeBase<Calendar> {
    public ScalarTypeCalendar(int jdbcType) {
        super(Calendar.class, false, jdbcType);
    }

    @Override
    public Calendar read(DataReader dataReader) throws SQLException {
        Timestamp timestamp = dataReader.getTimestamp();
        if (timestamp == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timestamp.getTime());
        return cal;
    }

    @Override
    public void bind(DataBind b, Calendar value) throws SQLException {
        if (value == null) {
            b.setNull(93);
        } else {
            Calendar date = value;
            if (this.jdbcType == 93) {
                Timestamp timestamp = new Timestamp(date.getTimeInMillis());
                b.setTimestamp(timestamp);
            } else {
                Date d = new Date(date.getTimeInMillis());
                b.setDate(d);
            }
        }
    }

    @Override
    public Object toJdbcType(Object value) {
        return BasicTypeConverter.convert(value, this.jdbcType);
    }

    @Override
    public Calendar toBeanType(Object value) {
        return BasicTypeConverter.toCalendar(value);
    }

    @Override
    public String formatValue(Calendar t) {
        Timestamp ts = new Timestamp(t.getTimeInMillis());
        return ts.toString();
    }

    @Override
    public Calendar parse(String value) {
        Timestamp ts = Timestamp.valueOf(value);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(ts.getTime());
        return calendar;
    }

    @Override
    public Calendar parseDateTime(long systemTimeMillis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(systemTimeMillis);
        return calendar;
    }

    @Override
    public boolean isDateTimeCapable() {
        return true;
    }
}

