/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.text.TextException;
import com.avaje.ebeaninternal.server.type.CtCompoundTypeScalarList;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.EnumToDbValueMap;
import com.avaje.ebeaninternal.server.type.ScalarType;
import com.avaje.ebeaninternal.server.type.ScalarTypeEnum;
import java.sql.SQLException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalarTypeEnumWithMapping
implements ScalarType,
ScalarTypeEnum {
    private final int dbType;
    private final Class enumType;
    private final EnumToDbValueMap beanDbMap;
    private final int length;

    public ScalarTypeEnumWithMapping(EnumToDbValueMap<?> beanDbMap, Class<?> enumType, int length) {
        this.beanDbMap = beanDbMap;
        this.enumType = enumType;
        this.dbType = beanDbMap.getDbType();
        this.length = length;
    }

    @Override
    public String getContraintInValues() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        sb.append("(");
        Iterator it = this.beanDbMap.dbValues();
        while (it.hasNext()) {
            Object dbValue = it.next();
            if (i++ > 0) {
                sb.append(",");
            }
            if (!this.beanDbMap.isIntegerType()) {
                sb.append("'");
            }
            sb.append(dbValue.toString());
            if (this.beanDbMap.isIntegerType()) continue;
            sb.append("'");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getJdbcType() {
        return this.dbType;
    }

    @Override
    public boolean isJdbcNative() {
        return false;
    }

    public Class<?> getType() {
        return this.enumType;
    }

    @Override
    public void bind(DataBind b, Object value) throws SQLException {
        this.beanDbMap.bind(b, value);
    }

    @Override
    public void loadIgnore(DataReader dataReader) {
        dataReader.incrementPos(1);
    }

    @Override
    public Object read(DataReader dataReader) throws SQLException {
        return this.beanDbMap.read(dataReader);
    }

    public Object toBeanType(Object dbValue) {
        return this.beanDbMap.getBeanValue(dbValue);
    }

    @Override
    public String format(Object t) {
        return t.toString();
    }

    public String formatValue(Object t) {
        return t.toString();
    }

    @Override
    public Object parse(String value) {
        return Enum.valueOf(this.enumType, value);
    }

    public Object parseDateTime(long systemTimeMillis) {
        throw new TextException("Not Supported");
    }

    @Override
    public boolean isDateTimeCapable() {
        return false;
    }

    @Override
    public Object toJdbcType(Object beanValue) {
        return this.beanDbMap.getDbValue(beanValue);
    }

    public boolean isDbNull(Object value) {
        return value == null;
    }

    public Object getDbNullValue(Object value) {
        return value;
    }

    @Override
    public void accumulateScalarTypes(String propName, CtCompoundTypeScalarList list) {
        list.addScalarType(propName, this);
    }

    public ScalarType<?> getScalarType() {
        return this;
    }
}

