/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebeaninternal.server.core.BasicTypeConverter;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.ScalarTypeBase;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalarTypeJodaDateTime
extends ScalarTypeBase<DateTime> {
    public ScalarTypeJodaDateTime() {
        super(DateTime.class, false, 93);
    }

    @Override
    public void bind(DataBind b, DateTime value) throws SQLException {
        if (value == null) {
            b.setNull(93);
        } else {
            Timestamp ts = new Timestamp(value.getMillis());
            b.setTimestamp(ts);
        }
    }

    @Override
    public DateTime read(DataReader dataReader) throws SQLException {
        Timestamp ts = dataReader.getTimestamp();
        if (ts == null) {
            return null;
        }
        return new DateTime(ts.getTime());
    }

    @Override
    public Object toJdbcType(Object value) {
        if (value instanceof DateTime) {
            return new Timestamp(((DateTime)value).getMillis());
        }
        return BasicTypeConverter.toTimestamp(value);
    }

    @Override
    public DateTime toBeanType(Object value) {
        if (value instanceof Date) {
            return new DateTime(((Date)value).getTime());
        }
        return (DateTime)value;
    }

    @Override
    public String formatValue(DateTime t) {
        Timestamp ts = new Timestamp(t.getMillis());
        return ts.toString();
    }

    @Override
    public DateTime parse(String value) {
        Timestamp ts = Timestamp.valueOf(value);
        return new DateTime(ts.getTime());
    }

    @Override
    public DateTime parseDateTime(long systemTimeMillis) {
        return new DateTime(systemTimeMillis);
    }

    @Override
    public boolean isDateTimeCapable() {
        return true;
    }
}

