/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebeaninternal.server.core.BasicTypeConverter;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.ScalarTypeBase;
import java.sql.SQLException;
import java.util.Date;
import org.joda.time.LocalDate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalarTypeJodaLocalDate
extends ScalarTypeBase<LocalDate> {
    public ScalarTypeJodaLocalDate() {
        super(LocalDate.class, false, 91);
    }

    @Override
    public void bind(DataBind b, LocalDate value) throws SQLException {
        if (value == null) {
            b.setNull(91);
        } else {
            java.sql.Date d = new java.sql.Date(value.toDateMidnight().getMillis());
            b.setDate(d);
        }
    }

    @Override
    public LocalDate read(DataReader dataReader) throws SQLException {
        java.sql.Date d = dataReader.getDate();
        if (d == null) {
            return null;
        }
        return new LocalDate(d.getTime());
    }

    @Override
    public Object toJdbcType(Object value) {
        if (value instanceof LocalDate) {
            return new java.sql.Date(((LocalDate)value).toDateMidnight().getMillis());
        }
        return BasicTypeConverter.toDate(value);
    }

    @Override
    public LocalDate toBeanType(Object value) {
        if (value instanceof Date) {
            return new LocalDate(((Date)value).getTime());
        }
        return (LocalDate)value;
    }

    @Override
    public String formatValue(LocalDate v) {
        java.sql.Date sqlDate = new java.sql.Date(v.toDateTimeAtStartOfDay().getMillis());
        return sqlDate.toString();
    }

    @Override
    public LocalDate parse(String value) {
        java.sql.Date ts = java.sql.Date.valueOf(value);
        return new LocalDate(ts.getTime());
    }

    @Override
    public LocalDate parseDateTime(long systemTimeMillis) {
        return new LocalDate(systemTimeMillis);
    }

    @Override
    public boolean isDateTimeCapable() {
        return true;
    }
}

