/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.util;

import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.server.core.SpiOrmQueryRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.DeployParser;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExpressionRequest
implements SpiExpressionRequest {
    private final SpiOrmQueryRequest<?> queryRequest;
    private final StringBuilder sb = new StringBuilder();
    private final ArrayList<Object> bindValues = new ArrayList();
    private final DeployParser deployParser;
    private int paramIndex;

    public DefaultExpressionRequest(SpiOrmQueryRequest<?> queryRequest, DeployParser deployParser) {
        this.queryRequest = queryRequest;
        this.deployParser = deployParser;
    }

    @Override
    public String parseDeploy(String logicalProp) {
        String s = this.deployParser.getDeployWord(logicalProp);
        return s == null ? logicalProp : s;
    }

    @Override
    public int nextParameter() {
        return ++this.paramIndex;
    }

    @Override
    public BeanDescriptor<?> getBeanDescriptor() {
        return this.queryRequest.getBeanDescriptor();
    }

    @Override
    public SpiOrmQueryRequest<?> getQueryRequest() {
        return this.queryRequest;
    }

    @Override
    public SpiExpressionRequest append(String sql) {
        this.sb.append(sql);
        return this;
    }

    @Override
    public void addBindValue(Object bindValue) {
        this.bindValues.add(bindValue);
    }

    public boolean includeProperty(String propertyName) {
        return true;
    }

    @Override
    public String getSql() {
        return this.sb.toString();
    }

    @Override
    public ArrayList<Object> getBindValues() {
        return this.bindValues;
    }
}

