package play.modules.ebean;

import play.Play;
import play.classloading.ApplicationClasses.ApplicationClass;

import com.avaje.ebean.enhance.asm.ClassReader;
import com.avaje.ebean.enhance.asm.ClassWriter;

public class HackedClassWriter extends ClassWriter
{

  public HackedClassWriter(ClassReader classReader, int flags)
  {
    super(classReader, flags);
  }

  public HackedClassWriter(final int flags)
  {
    super(flags);
  }

  @Override
  @SuppressWarnings("unchecked")
  protected String getCommonSuperClass(String type1, String type2)
  {
    Class c, d;
    try {
      c = findClass(type1.replace('/', '.'));
      d = findClass(type2.replace('/', '.'));
    } catch (Exception e) {
      throw new RuntimeException(e.toString());
    }
    if (c == null || d == null) {
      // Hack. Since we are constructing current class by the time this method is called (no javaClass)
      // we can't tell it's supper class. A possible solution is to set ApplicationClass.javaClass before the enhancement step.
      return "java/lang/Object";
    }

    if (c.isAssignableFrom(d)) {
      return type1;
    }
    if (d.isAssignableFrom(c)) {
      return type2;
    }
    if (c.isInterface() || d.isInterface()) {
      return "java/lang/Object";
    } else {
      do {
        c = c.getSuperclass();
      } while (!c.isAssignableFrom(d));
      return c.getName().replace('.', '/');
    }
  }

  @SuppressWarnings("unchecked")
  private Class findClass(String name) throws ClassNotFoundException
  {
    ApplicationClass ac = Play.classes.getApplicationClass(name);
    if (ac == null) return Class.forName(name);
    return ac.javaClass;
  }

}
