/*
 * Decompiled with CFR 0.152.
 */
package play.modules.ecss;

import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.mvc.Http;
import play.utils.Utils;
import play.vfs.VirtualFile;

public class ECssPlugin
extends PlayPlugin {
    static Pattern pattern = Pattern.compile("[$]([-A-Za-z1-9_]+)\\s*:\\s*(.*?);", 8);
    static Map<String, String[]> css3 = new HashMap<String, String[]>();

    public boolean serveStatic(VirtualFile virtualFile, Http.Request request, Http.Response response) {
        if (virtualFile.getName().endsWith(".css")) {
            if (Play.mode == Play.Mode.DEV) {
                response.setHeader("Cache-Control", "no-cache");
                this.doIt(virtualFile, request, response);
            } else {
                long l = virtualFile.lastModified();
                String string = l + "-" + virtualFile.hashCode();
                if (!ECssPlugin.isModified(string, l, request)) {
                    response.setHeader("Etag", string);
                    response.status = 304;
                } else {
                    response.setHeader("Last-Modified", Utils.getHttpDateFormatter().format(new Date(l)));
                    response.setHeader("Cache-Control", "max-age=3600");
                    response.setHeader("Etag", string);
                    this.doIt(virtualFile, request, response);
                }
            }
            return true;
        }
        return false;
    }

    void doIt(VirtualFile virtualFile, Http.Request request, Http.Response response) {
        try {
            String string = virtualFile.contentAsString();
            Matcher matcher = pattern.matcher(string);
            HashMap<Iterator<String>, String> hashMap = new HashMap<Iterator<String>, String>();
            while (matcher.find()) {
                Iterator<String> iterator = matcher.group(1);
                String string2 = matcher.group(2);
                hashMap.put(iterator, string2);
            }
            string = string.replaceAll("[$]([-A-Za-z1-9_]+)\\s*:\\s*(.*?);", "");
            for (String string2 : hashMap.keySet()) {
                string = string.replace("$" + string2, (CharSequence)hashMap.get(string2));
            }
            for (String string2 : css3.keySet()) {
                StringBuffer stringBuffer = new StringBuffer();
                matcher = Pattern.compile("(\\s)" + Pattern.quote(string2) + "\\s*:([^;]*);").matcher(string);
                while (matcher.find()) {
                    String string3 = "$1";
                    for (String string4 : css3.get(string2)) {
                        string3 = string3 + "" + string4 + ":$2;";
                    }
                    matcher.appendReplacement(stringBuffer, string3);
                }
                matcher.appendTail(stringBuffer);
                string = stringBuffer.toString();
            }
            response.contentType = "text/css";
            response.out.write(string.getBytes("utf-8"));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    static boolean isModified(String string, long l, Http.Request request) {
        if (!request.headers.containsKey("If-None-Match") || !request.headers.containsKey("If-Modified-Since")) {
            return true;
        }
        String string2 = ((Http.Header)request.headers.get("If-None-Match")).value();
        if (!string2.equals(string)) {
            return true;
        }
        try {
            Date date = Utils.getHttpDateFormatter().parse(((Http.Header)request.headers.get("If-Modified-Since")).value());
            if (date.getTime() >= l) {
                return false;
            }
        }
        catch (ParseException parseException) {
            Logger.error((String)"Can't parse date", (Object[])new Object[]{parseException});
        }
        return true;
    }

    static {
        css3.put("border-radius", new String[]{"-moz-border-radius", "-webkit-border-radius"});
        css3.put("border-top-right-radius", new String[]{"-moz-border-radius-topright", "-webkit-border-top-right-radius"});
        css3.put("border-top-left-radius", new String[]{"-moz-border-radius-topleft", "-webkit-border-top-left-radius"});
        css3.put("border-bottom-right-radius", new String[]{"-moz-border-radius-bottomright", "-webkit-border-bottom-right-radius"});
        css3.put("border-bottom-left-radius", new String[]{"-moz-border-radius-bottomleft", "-webkit-border-bottom-left-radius"});
        css3.put("box-shadow", new String[]{"-moz-box-shadow", "-webkit-box-shadow"});
    }
}

