/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch;

import javax.persistence.MappedSuperclass;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import play.Logger;
import play.Play;
import play.db.jpa.Model;
import play.modules.elasticsearch.ElasticSearchAdapter;
import play.modules.elasticsearch.ElasticSearchPlugin;
import play.modules.elasticsearch.ExceptionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MappedSuperclass
public class ElasticSearchModel<T extends ElasticSearchModel>
extends Model {
    private static final long serialVersionUID = 1L;

    @PostPersist
    public void postPersist() {
        try {
            Logger.info((String)("Elastic Search - Index Request: " + (Object)((Object)this) + ", Key: " + this.id), (Object[])new Object[0]);
            ElasticSearchPlugin plugin = (ElasticSearchPlugin)((Object)Play.plugin(ElasticSearchPlugin.class));
            ElasticSearchAdapter.indexModel(plugin.client(), this);
            Logger.debug((String)"Elastic Event Done!", (Object[])new Object[0]);
        }
        catch (Throwable t) {
            Logger.error((String)ExceptionUtil.getStackTrace(t), (Object[])new Object[0]);
            throw new RuntimeException(t);
        }
    }

    @PostRemove
    public void postRemove() {
        try {
            Logger.info((String)("Elastic Search - Remove Request: " + (Object)((Object)this) + ", Key: " + this.id), (Object[])new Object[0]);
            ElasticSearchPlugin plugin = (ElasticSearchPlugin)((Object)Play.plugin(ElasticSearchPlugin.class));
            ElasticSearchAdapter.deleteModel(plugin.client(), this);
            Logger.debug((String)"Elastic Delete Event Done!", (Object[])new Object[0]);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

