/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;
import play.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassesUtil<T> {
    private static final byte[] JAR_MAGIC = new byte[]{80, 75, 3, 4};
    private static final Pattern JAVA_IDENTIFIER_PATTERN = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
    private Set<Class<? extends T>> matches = new HashSet<Class<? extends T>>();
    private ClassLoader classloader;

    public Set<Class<? extends T>> getClasses() {
        return this.matches;
    }

    public ClassLoader getClassLoader() {
        return this.classloader == null ? Thread.currentThread().getContextClassLoader() : this.classloader;
    }

    public void setClassLoader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public ClassesUtil<T> findImplementations(Class<?> parent, String ... packageNames) {
        if (packageNames == null) {
            return this;
        }
        IsA test = new IsA(parent);
        for (String pkg : packageNames) {
            this.find(test, pkg);
        }
        return this;
    }

    public ClassesUtil<T> findAnnotated(Class<? extends Annotation> annotation, String ... packageNames) {
        if (packageNames == null) {
            return this;
        }
        AnnotatedWith test = new AnnotatedWith(annotation);
        for (String pkg : packageNames) {
            this.find(test, pkg);
        }
        return this;
    }

    public ClassesUtil<T> find(Test test, String packageName) {
        String path = this.getPackagePath(packageName);
        try {
            ArrayList<URL> urls = Collections.list(this.getClassLoader().getResources(path));
            for (URL url : urls) {
                List<String> children = this.listClassResources(url, path);
                for (String child : children) {
                    this.addIfMatching(test, child);
                }
            }
        }
        catch (IOException ioe) {
            Logger.error((String)("Could not read package: " + packageName + " -- "), (Object[])new Object[]{ioe});
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> listClassResources(URL url, String path) throws IOException {
        Logger.debug((String)("Listing classes in " + url), (Object[])new Object[0]);
        InputStream is = null;
        try {
            ArrayList<String> resources = new ArrayList();
            URL jarUrl = this.findJarForResource(url, path);
            if (jarUrl != null) {
                is = jarUrl.openStream();
                resources = this.listClassResources(new JarInputStream(is), path);
            } else {
                List<String> children = new ArrayList<String>();
                try {
                    if (this.isJar(url)) {
                        JarEntry entry;
                        is = url.openStream();
                        JarInputStream jarInput = new JarInputStream(is);
                        while ((entry = jarInput.getNextJarEntry()) != null) {
                            Logger.debug((String)("Jar entry: " + entry.getName()), (Object[])new Object[0]);
                            if (!this.isRelevantResource(entry.getName())) continue;
                            children.add(entry.getName());
                        }
                    } else {
                        String line;
                        is = url.openStream();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                        while ((line = reader.readLine()) != null) {
                            Logger.debug((String)("Reader entry: " + line), (Object[])new Object[0]);
                            if (!this.isRelevantResource(line)) continue;
                            children.add(line);
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    if ("file".equals(url.getProtocol())) {
                        File file = new File(url.getFile());
                        Logger.debug((String)("Listing directory " + file.getAbsolutePath()), (Object[])new Object[0]);
                        if (file.isDirectory()) {
                            children = Arrays.asList(file.list(new FilenameFilter(){

                                public boolean accept(File dir, String name) {
                                    return ClassesUtil.this.isRelevantResource(name);
                                }
                            }));
                        }
                    }
                    throw e;
                }
                String prefix = url.toExternalForm();
                if (!prefix.endsWith("/")) {
                    prefix = prefix + "/";
                }
                for (String child : children) {
                    String resourcePath = path + "/" + child;
                    if (child.endsWith(".class")) {
                        Logger.debug((String)("Found class file: " + resourcePath), (Object[])new Object[0]);
                        resources.add(resourcePath);
                        continue;
                    }
                    URL childUrl = new URL(prefix + child);
                    resources.addAll(this.listClassResources(childUrl, resourcePath));
                }
            }
            ArrayList<String> arrayList = resources;
            return arrayList;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {}
        }
    }

    protected List<String> listClassResources(JarInputStream jar, String path) throws IOException {
        JarEntry entry;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        ArrayList<String> resources = new ArrayList<String>();
        while ((entry = jar.getNextJarEntry()) != null) {
            if (entry.isDirectory()) continue;
            String name = entry.getName();
            if (!name.startsWith("/")) {
                name = "/" + name;
            }
            if (!name.endsWith(".class") || !name.startsWith(path)) continue;
            Logger.debug((String)("Found class file: " + name), (Object[])new Object[0]);
            resources.add(name.substring(1));
        }
        return resources;
    }

    protected URL findJarForResource(URL url, String path) throws MalformedURLException {
        Logger.debug((String)("Find JAR URL: " + url), (Object[])new Object[0]);
        try {
            while (true) {
                url = new URL(url.getFile());
                Logger.debug((String)("Inner URL: " + url), (Object[])new Object[0]);
            }
        }
        catch (MalformedURLException e) {
            StringBuilder jarUrl = new StringBuilder(url.toExternalForm());
            int index = jarUrl.lastIndexOf(".jar");
            if (index < 0) {
                Logger.debug((String)("Not a JAR: " + jarUrl), (Object[])new Object[0]);
                return null;
            }
            jarUrl.setLength(index + 4);
            Logger.debug((String)("Extracted JAR URL: " + jarUrl), (Object[])new Object[0]);
            try {
                URL testUrl = new URL(jarUrl.toString());
                if (this.isJar(testUrl)) {
                    return testUrl;
                }
                Logger.debug((String)("Not a JAR: " + jarUrl), (Object[])new Object[0]);
                jarUrl.replace(0, jarUrl.length(), testUrl.getFile());
                File file = new File(jarUrl.toString());
                if (file.exists()) {
                    Logger.debug((String)("Trying real file: " + file.getAbsolutePath()), (Object[])new Object[0]);
                    testUrl = file.toURI().toURL();
                    if (this.isJar(testUrl)) {
                        return testUrl;
                    }
                }
            }
            catch (MalformedURLException e2) {
                Logger.warn((String)("Invalid JAR URL: " + jarUrl), (Object[])new Object[0]);
            }
            Logger.debug((String)("Not a JAR: " + jarUrl), (Object[])new Object[0]);
            return null;
        }
    }

    protected String getPackagePath(String packageName) {
        return packageName == null ? null : packageName.replace('.', '/');
    }

    protected boolean isRelevantResource(String resourceName) {
        return resourceName != null && (resourceName.endsWith(".class") || JAVA_IDENTIFIER_PATTERN.matcher(resourceName).matches());
    }

    protected boolean isJar(URL url) {
        return this.isJar(url, new byte[JAR_MAGIC.length]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isJar(URL url, byte[] buffer) {
        InputStream is = null;
        try {
            is = url.openStream();
            is.read(buffer, 0, JAR_MAGIC.length);
            if (Arrays.equals(buffer, JAR_MAGIC)) {
                Logger.debug((String)("Found JAR: " + url), (Object[])new Object[0]);
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {}
        }
        return false;
    }

    protected void addIfMatching(Test test, String fqn) {
        try {
            String externalName = fqn.substring(0, fqn.indexOf(46)).replace('/', '.');
            ClassLoader loader = this.getClassLoader();
            Logger.debug((String)("Checking to see if class " + externalName + " matches criteria [" + test + "]"), (Object[])new Object[0]);
            Class<?> type = loader.loadClass(externalName);
            if (test.matches(type)) {
                this.matches.add(type);
            }
        }
        catch (Throwable t) {
            Logger.warn((String)("Could not examine class '" + fqn + "'" + " due to a " + t.getClass().getName() + " with message: " + t.getMessage()), (Object[])new Object[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotatedWith
    implements Test {
        private Class<? extends Annotation> annotation;

        public AnnotatedWith(Class<? extends Annotation> annotation) {
            this.annotation = annotation;
        }

        public boolean matches(Class type) {
            return type != null && type.isAnnotationPresent(this.annotation);
        }

        public String toString() {
            return "annotated with @" + this.annotation.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IsA
    implements Test {
        private Class<?> parent;

        public IsA(Class<?> parentType) {
            this.parent = parentType;
        }

        public boolean matches(Class type) {
            return type != null && this.parent.isAssignableFrom(type);
        }

        public String toString() {
            return "is assignable to " + this.parent.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Test {
        public boolean matches(Class<?> var1);
    }
}

