/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import play.Logger;
import play.db.Model;
import play.modules.elasticsearch.ElasticSearchIgnore;
import play.modules.elasticsearch.ExceptionUtil;
import play.modules.elasticsearch.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElasticSearchAdapter {
    private static List<String> IGNORE_FIELDS = new ArrayList<String>();

    public static void startIndex(Client client, Class<?> clazz) {
        ElasticSearchAdapter.index(client, ElasticSearchAdapter.getIndexName(clazz));
    }

    public static void startIndex(Client client, String clazz) {
        ElasticSearchAdapter.index(client, ElasticSearchAdapter.getIndexName(clazz));
    }

    private static void index(Client client, String indexName) {
        try {
            Logger.debug((String)"Starting Elastic Search Index %s", (Object[])new Object[]{indexName});
            CreateIndexResponse response = (CreateIndexResponse)client.admin().indices().create(new CreateIndexRequest(indexName)).actionGet();
            Logger.debug((String)"Response: %s", (Object[])new Object[]{response});
        }
        catch (IndexAlreadyExistsException iaee) {
            Logger.debug((String)"Index already exists: %s", (Object[])new Object[]{indexName});
        }
        catch (Throwable t) {
            Logger.warn((String)ExceptionUtil.getStackTrace(t), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Model> void indexModel(Client client, T model) throws Exception {
        Logger.debug((String)"Start Index Model: %s", (Object[])new Object[]{model});
        XContentBuilder contentBuilder = null;
        try {
            String indexName = ElasticSearchAdapter.getIndexName(model);
            Logger.debug((String)"Index Name: %s", (Object[])new Object[]{indexName});
            List<String> fields = ReflectionUtil.getAllFieldNamesWithoutAnnotation(model.getClass(), ElasticSearchIgnore.class);
            contentBuilder = XContentFactory.jsonBuilder().startObject();
            for (String name : fields) {
                if (!StringUtils.isNotBlank((String)(name = name.replaceFirst(model.getClass().getCanonicalName() + ".", ""))) || IGNORE_FIELDS.contains(name)) continue;
                if (!name.equalsIgnoreCase("id")) {
                    Object value = ReflectionUtil.getFieldValue(model, name);
                    if (value != null) {
                        Logger.debug((String)("Field: " + name + ", Value: " + value), (Object[])new Object[0]);
                        contentBuilder = contentBuilder.field(name, value);
                        continue;
                    }
                    Logger.debug((String)("No Value for Field: " + name), (Object[])new Object[0]);
                    continue;
                }
                contentBuilder = contentBuilder.field(name, model._key());
            }
            contentBuilder = contentBuilder.endObject().prettyPrint();
            IndexResponse response = (IndexResponse)client.prepareIndex(indexName, indexName, model._key().toString()).setSource(contentBuilder).execute().actionGet();
            Logger.info((String)"Index Response: %s", (Object[])new Object[]{response});
        }
        finally {
            if (contentBuilder != null) {
                contentBuilder.close();
            }
        }
    }

    public static <T extends Model> void deleteModel(Client client, T model) throws Exception {
        Logger.debug((String)"Delete Model: %s", (Object[])new Object[]{model});
        DeleteResponse response = (DeleteResponse)client.prepareDelete(ElasticSearchAdapter.getIndexName(model), ElasticSearchAdapter.getIndexName(model), String.valueOf(model._key())).setOperationThreaded(false).execute().actionGet();
        Logger.debug((String)"Delete Response: %s", (Object[])new Object[]{response});
    }

    private static String getIndexName(Model model) {
        return ElasticSearchAdapter.getIndexName(model.getClass());
    }

    private static String getIndexName(Class<?> clazz) {
        return ElasticSearchAdapter.getIndexName(clazz.getName());
    }

    private static String getIndexName(String clazz) {
        Logger.debug((String)"Class: %s", (Object[])new Object[]{clazz});
        String value = clazz.toLowerCase().trim().replace('.', '_');
        Logger.debug((String)"Index Name: %s", (Object[])new Object[]{value});
        return value;
    }

    static {
        IGNORE_FIELDS.add("avoidCascadeSaveLoops");
        IGNORE_FIELDS.add("willBeSaved");
        IGNORE_FIELDS.add("serialVersionId");
    }
}

