/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch;

import org.apache.commons.lang.StringUtils;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.modules.elasticsearch.ElasticSearchAdapter;
import play.modules.elasticsearch.ExceptionUtil;
import play.mvc.Router;

public class ElasticSearchPlugin
extends PlayPlugin {
    private ThreadLocal<Client> _session = new ThreadLocal();
    public static boolean started = false;

    public Client client() {
        return this._session.get();
    }

    public void onApplicationStart() {
        if (this._session.get() != null || started) {
            Logger.debug((String)"Elastic Search Started Already!", (Object[])new Object[0]);
            return;
        }
        ImmutableSettings.Builder settings = ImmutableSettings.settingsBuilder();
        settings.build();
        NodeBuilder nb = NodeBuilder.nodeBuilder().settings((Settings.Builder)settings);
        boolean localMode = false;
        if (!Play.configuration.containsKey("elasticsearch.local")) {
            localMode = Boolean.getBoolean(Play.configuration.getProperty("elasticsearch.local"));
            nb = nb.local(localMode);
        }
        boolean clientMode = false;
        if (!Play.configuration.containsKey("elasticsearch.client")) {
            clientMode = Boolean.getBoolean(Play.configuration.getProperty("elasticsearch.client"));
            nb = nb.client(clientMode);
        }
        if (!localMode && !clientMode) {
            localMode = true;
            nb = nb.local(localMode);
        }
        if (localMode) {
            Logger.info((String)"Starting Elastic Search for Play! in Local Mode", (Object[])new Object[0]);
        } else {
            Logger.info((String)"Connecting Play! to Elastic Search in Client Mode", (Object[])new Object[0]);
        }
        started = true;
        Node node = nb.node();
        Client client = node.client();
        try {
            String[] classes;
            String models = Play.configuration.getProperty("elasticsearch.models", "");
            for (String clazz : classes = StringUtils.split((String)models, (String)",")) {
                Logger.info((String)"Start Index for Class: %s", (Object[])new Object[]{clazz});
                ElasticSearchAdapter.startIndex(client, clazz);
            }
        }
        catch (Throwable t) {
            Logger.warn((String)ExceptionUtil.getStackTrace(t), (Object[])new Object[0]);
            throw new RuntimeException(t);
        }
        Router.addRoute((String)"GET", (String)"/es-admin/", (String)"ElasticSearchAdmin.index");
        Router.addRoute((String)"GET", (String)"/es-admin/lib", (String)"staticDir:public");
        this._session.set(client);
    }
}

