/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.node;

import java.io.IOException;
import java.math.BigDecimal;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.io.NumberOutput;
import org.codehaus.jackson.map.node.NumericNode;

public final class IntNode
extends NumericNode {
    final int mValue;

    public IntNode(int v) {
        this.mValue = v;
    }

    public static IntNode valueOf(int i) {
        return new IntNode(i);
    }

    public boolean isIntegralNumber() {
        return true;
    }

    public boolean isInt() {
        return true;
    }

    public Number getNumberValue() {
        return this.mValue;
    }

    public int getIntValue() {
        return this.mValue;
    }

    public long getLongValue() {
        return this.mValue;
    }

    public double getDoubleValue() {
        return this.mValue;
    }

    public BigDecimal getDecimalValue() {
        return BigDecimal.valueOf(this.mValue);
    }

    public String getValueAsText() {
        return NumberOutput.toString(this.mValue);
    }

    public void writeTo(JsonGenerator jg) throws IOException, JsonGenerationException {
        jg.writeNumber(this.mValue);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        return ((IntNode)o).mValue == this.mValue;
    }
}

