/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.status;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.admin.indices.status.IndexStatus;
import org.elasticsearch.action.admin.indices.status.ShardStatus;
import org.elasticsearch.action.support.broadcast.BroadcastOperationResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;

public class IndicesStatusResponse
extends BroadcastOperationResponse {
    protected ShardStatus[] shards;
    private Map<String, Settings> indicesSettings = ImmutableMap.of();
    private Map<String, IndexStatus> indicesStatus;

    IndicesStatusResponse() {
    }

    IndicesStatusResponse(ShardStatus[] shards, ClusterState clusterState, int totalShards, int successfulShards, int failedShards, List<ShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.shards = shards;
        this.indicesSettings = Maps.newHashMap();
        for (ShardStatus shard : shards) {
            if (this.indicesSettings.containsKey(shard.shardRouting().index())) continue;
            this.indicesSettings.put(shard.shardRouting().index(), clusterState.metaData().index(shard.shardRouting().index()).settings());
        }
    }

    public ShardStatus[] shards() {
        return this.shards;
    }

    public ShardStatus[] getShards() {
        return this.shards;
    }

    public ShardStatus getAt(int position) {
        return this.shards[position];
    }

    public IndexStatus index(String index) {
        return this.indices().get(index);
    }

    public Map<String, IndexStatus> getIndices() {
        return this.indices();
    }

    public Map<String, IndexStatus> indices() {
        if (this.indicesStatus != null) {
            return this.indicesStatus;
        }
        HashMap<String, IndexStatus> indicesStatus = Maps.newHashMap();
        for (String index : this.indicesSettings.keySet()) {
            ArrayList<ShardStatus> shards = Lists.newArrayList();
            for (ShardStatus shard : this.shards()) {
                if (!shard.shardRouting().index().equals(index)) continue;
                shards.add(shard);
            }
            indicesStatus.put(index, new IndexStatus(index, this.indicesSettings.get(index), shards.toArray(new ShardStatus[shards.size()])));
        }
        this.indicesStatus = indicesStatus;
        return indicesStatus;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.shards().length);
        for (ShardStatus status : this.shards()) {
            status.writeTo(out);
        }
        out.writeVInt(this.indicesSettings.size());
        for (Map.Entry<String, Settings> entry : this.indicesSettings.entrySet()) {
            out.writeUTF(entry.getKey());
            ImmutableSettings.writeSettingsToStream(entry.getValue(), out);
        }
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shards = new ShardStatus[in.readVInt()];
        for (int i = 0; i < this.shards.length; ++i) {
            this.shards[i] = ShardStatus.readIndexShardStatus(in);
        }
        this.indicesSettings = Maps.newHashMap();
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            this.indicesSettings.put(in.readUTF(), ImmutableSettings.readSettingsFromStream(in));
        }
    }
}

