/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search.type;

import java.io.IOException;
import java.util.Collection;
import java.util.regex.Pattern;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.search.type.ParsedScrollId;
import org.elasticsearch.action.search.type.TransportSearchCache;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Base64;
import org.elasticsearch.common.Unicode;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.internal.InternalScrollSearchRequest;
import org.elasticsearch.search.internal.InternalSearchRequest;

public abstract class TransportSearchHelper {
    private static final Pattern scrollIdPattern = Pattern.compile(";");

    public static ShardSearchFailure[] buildShardFailures(Collection<ShardSearchFailure> shardFailures, TransportSearchCache searchCache) {
        ShardSearchFailure[] ret = shardFailures.isEmpty() ? ShardSearchFailure.EMPTY_ARRAY : shardFailures.toArray(ShardSearchFailure.EMPTY_ARRAY);
        searchCache.releaseShardFailures(shardFailures);
        return ret;
    }

    public static InternalSearchRequest internalSearchRequest(ShardRouting shardRouting, int numberOfShards, SearchRequest request) {
        InternalSearchRequest internalRequest = new InternalSearchRequest(shardRouting, numberOfShards);
        internalRequest.source(request.source(), request.sourceOffset(), request.sourceLength());
        internalRequest.extraSource(request.extraSource(), request.extraSourceOffset(), request.extraSourceLength());
        internalRequest.scroll(request.scroll());
        internalRequest.timeout(request.timeout());
        internalRequest.types(request.types());
        return internalRequest;
    }

    public static InternalScrollSearchRequest internalScrollSearchRequest(long id, SearchScrollRequest request) {
        InternalScrollSearchRequest internalRequest = new InternalScrollSearchRequest(id);
        internalRequest.scroll(request.scroll());
        return internalRequest;
    }

    public static String buildScrollId(SearchType searchType, Iterable<? extends SearchPhaseResult> searchPhaseResults) throws IOException {
        if (searchType == SearchType.DFS_QUERY_THEN_FETCH || searchType == SearchType.QUERY_THEN_FETCH) {
            return TransportSearchHelper.buildScrollId("queryThenFetch", searchPhaseResults);
        }
        if (searchType == SearchType.QUERY_AND_FETCH || searchType == SearchType.DFS_QUERY_AND_FETCH) {
            return TransportSearchHelper.buildScrollId("queryAndFetch", searchPhaseResults);
        }
        throw new ElasticSearchIllegalStateException();
    }

    public static String buildScrollId(String type, Iterable<? extends SearchPhaseResult> searchPhaseResults) throws IOException {
        StringBuilder sb = new StringBuilder().append(type).append(';');
        for (SearchPhaseResult searchPhaseResult : searchPhaseResults) {
            sb.append(searchPhaseResult.id()).append(':').append(searchPhaseResult.shardTarget().nodeId()).append(';');
        }
        return Base64.encodeBytes(Unicode.fromStringAsBytes(sb.toString()), 16);
    }

    public static ParsedScrollId parseScrollId(String scrollId) {
        try {
            scrollId = Unicode.fromBytes(Base64.decode(scrollId, 16));
        }
        catch (IOException e) {
            throw new ElasticSearchIllegalArgumentException("Failed to decode scrollId", e);
        }
        String[] elements = scrollIdPattern.split(scrollId);
        Tuple[] values = new Tuple[elements.length - 1];
        for (int i = 1; i < elements.length; ++i) {
            String element = elements[i];
            int index = element.indexOf(58);
            values[i - 1] = new Tuple<String, Long>(element.substring(index + 1), Long.parseLong(element.substring(0, index)));
        }
        return new ParsedScrollId(scrollId, elements[0], values);
    }

    private TransportSearchHelper() {
    }
}

