/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.lzf;

import java.io.IOException;
import java.io.OutputStream;
import org.elasticsearch.common.compress.lzf.LZFChunk;

public class ChunkEncoder {
    private static final int MIN_BLOCK_TO_COMPRESS = 16;
    private static final int MIN_HASH_SIZE = 256;
    private static final int MAX_HASH_SIZE = 16384;
    private static final int MAX_OFF = 8192;
    private static final int MAX_REF = 264;
    private final byte[] _encodeBuffer;
    private final int[] _hashTable;
    private final int _hashModulo;

    public ChunkEncoder(int totalLength) {
        int largestChunkLen = Math.max(totalLength, 65535);
        int hashLen = ChunkEncoder.calcHashLen(largestChunkLen);
        this._hashTable = new int[hashLen];
        this._hashModulo = hashLen - 1;
        int bufferLen = largestChunkLen + (largestChunkLen + 31 >> 5);
        this._encodeBuffer = new byte[bufferLen];
    }

    public int encodeChunk(OutputStream os, byte[] data, int offset, int len) throws IOException {
        int compLen;
        if (len >= 16 && (compLen = this.tryCompress(data, offset, offset + len, this._encodeBuffer, 0)) < len - 2) {
            return LZFChunk.createCompressed(os, len, this._encodeBuffer, 0, compLen);
        }
        return LZFChunk.createNonCompressed(os, data, offset, len);
    }

    public LZFChunk encodeChunk(byte[] data, int offset, int len) {
        int compLen;
        if (len >= 16 && (compLen = this.tryCompress(data, offset, offset + len, this._encodeBuffer, 0)) < len - 2) {
            return LZFChunk.createCompressed(len, this._encodeBuffer, 0, compLen);
        }
        return LZFChunk.createNonCompressed(data, offset, len);
    }

    private static int calcHashLen(int chunkSize) {
        int hashLen;
        if ((chunkSize += chunkSize) >= 16384) {
            return 16384;
        }
        for (hashLen = 256; hashLen < chunkSize; hashLen += hashLen) {
        }
        return hashLen;
    }

    private int first(byte[] in, int inPos) {
        return (in[inPos] << 8) + (in[inPos + 1] & 0xFF);
    }

    private static int next(int v, byte[] in, int inPos) {
        return (v << 8) + (in[inPos + 2] & 0xFF);
    }

    private int hash(int h) {
        return h * 57321 >> 9 & this._hashModulo;
    }

    private int tryCompress(byte[] in, int inPos, int inEnd, byte[] out, int outPos) {
        int literals = 0;
        ++outPos;
        int hash = this.first(in, 0);
        inEnd -= 4;
        int firstPos = inPos;
        while (inPos < inEnd) {
            byte p2 = in[inPos + 2];
            hash = (hash << 8) + (p2 & 0xFF);
            int off = this.hash(hash);
            int ref = this._hashTable[off];
            this._hashTable[off] = inPos;
            if (ref < inPos && ref >= firstPos && (off = inPos - ref - 1) < 8192 && in[ref + 2] == p2 && in[ref + 1] == (byte)(hash >> 8) && in[ref] == (byte)(hash >> 16)) {
                int len;
                int maxLen = inEnd - inPos + 2;
                if (maxLen > 264) {
                    maxLen = 264;
                }
                if (literals == 0) {
                    --outPos;
                } else {
                    out[outPos - literals - 1] = (byte)(literals - 1);
                    literals = 0;
                }
                for (len = 3; len < maxLen && in[ref + len] == in[inPos + len]; ++len) {
                }
                if ((len -= 2) < 7) {
                    out[outPos++] = (byte)((off >> 8) + (len << 5));
                } else {
                    out[outPos++] = (byte)((off >> 8) + 224);
                    out[outPos++] = (byte)(len - 7);
                }
                out[outPos++] = (byte)off;
                ++outPos;
                hash = this.first(in, inPos += len);
                hash = ChunkEncoder.next(hash, in, inPos);
                this._hashTable[this.hash((int)hash)] = inPos++;
                hash = ChunkEncoder.next(hash, in, inPos);
                this._hashTable[this.hash((int)hash)] = inPos++;
                continue;
            }
            out[outPos++] = in[inPos++];
            if (++literals != 32) continue;
            out[outPos - literals - 1] = (byte)(literals - 1);
            literals = 0;
            ++outPos;
        }
        inEnd += 4;
        while (inPos < inEnd) {
            out[outPos++] = in[inPos++];
            if (++literals != 32) continue;
            out[outPos - literals - 1] = (byte)(literals - 1);
            literals = 0;
            ++outPos;
        }
        out[outPos - literals - 1] = (byte)(literals - 1);
        if (literals == 0) {
            --outPos;
        }
        return outPos;
    }
}

