/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.lzf;

import java.io.IOException;
import java.io.OutputStream;
import org.elasticsearch.common.compress.lzf.ChunkEncoder;
import org.elasticsearch.common.compress.lzf.LZFChunk;
import org.elasticsearch.common.thread.ThreadLocals;

public class LZFEncoder {
    public static final ThreadLocal<ThreadLocals.CleanableValue<ChunkEncoder>> cachedEncoder = new ThreadLocal<ThreadLocals.CleanableValue<ChunkEncoder>>(){

        @Override
        protected ThreadLocals.CleanableValue<ChunkEncoder> initialValue() {
            return new ThreadLocals.CleanableValue<ChunkEncoder>(new ChunkEncoder(65535));
        }
    };

    private LZFEncoder() {
    }

    public static byte[] encode(byte[] data) throws IOException {
        return LZFEncoder.encode(data, data.length);
    }

    public static void encode(OutputStream os, byte[] data, int length) throws IOException {
        int left = length;
        ChunkEncoder enc = new ChunkEncoder(left);
        int chunkLen = Math.min(65535, left);
        enc.encodeChunk(os, data, 0, chunkLen);
        if ((left -= chunkLen) < 1) {
            return;
        }
        int inputOffset = chunkLen;
        do {
            chunkLen = Math.min(left, 65535);
            enc.encodeChunk(os, data, inputOffset, chunkLen);
            inputOffset += chunkLen;
        } while ((left -= chunkLen) > 0);
    }

    public static byte[] encodeWithCache(byte[] data, int length) throws IOException {
        int left = length;
        ChunkEncoder enc = cachedEncoder.get().get();
        int chunkLen = Math.min(65535, left);
        LZFChunk first = enc.encodeChunk(data, 0, chunkLen);
        if ((left -= chunkLen) < 1) {
            return first.getData();
        }
        int resultBytes = first.length();
        int inputOffset = chunkLen;
        LZFChunk last = first;
        do {
            chunkLen = Math.min(left, 65535);
            LZFChunk chunk = enc.encodeChunk(data, inputOffset, chunkLen);
            inputOffset += chunkLen;
            resultBytes += chunk.length();
            last.setNext(chunk);
            last = chunk;
        } while ((left -= chunkLen) > 0);
        byte[] result = new byte[resultBytes];
        int ptr = 0;
        while (first != null) {
            ptr = first.copyTo(result, ptr);
            first = first.next();
        }
        return result;
    }

    public static byte[] encode(byte[] data, int length) throws IOException {
        int left = length;
        ChunkEncoder enc = new ChunkEncoder(left);
        int chunkLen = Math.min(65535, left);
        LZFChunk first = enc.encodeChunk(data, 0, chunkLen);
        if ((left -= chunkLen) < 1) {
            return first.getData();
        }
        int resultBytes = first.length();
        int inputOffset = chunkLen;
        LZFChunk last = first;
        do {
            chunkLen = Math.min(left, 65535);
            LZFChunk chunk = enc.encodeChunk(data, inputOffset, chunkLen);
            inputOffset += chunkLen;
            resultBytes += chunk.length();
            last.setNext(chunk);
            last = chunk;
        } while ((left -= chunkLen) > 0);
        byte[] result = new byte[resultBytes];
        int ptr = 0;
        while (first != null) {
            ptr = first.copyTo(result, ptr);
            first = first.next();
        }
        return result;
    }
}

