/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.lzf;

import java.io.IOException;
import java.io.OutputStream;
import org.elasticsearch.common.compress.lzf.ChunkEncoder;

public class LZFOutputStream
extends OutputStream {
    private static int OUTPUT_BUFFER_SIZE = 65535;
    private static int BYTE_MASK = 255;
    private final OutputStream outputStream;
    private final byte[] outputBuffer = new byte[OUTPUT_BUFFER_SIZE];
    private final ChunkEncoder encoder = new ChunkEncoder(OUTPUT_BUFFER_SIZE);
    private int position = 0;

    public LZFOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void write(int singleByte) throws IOException {
        if (this.position >= this.outputBuffer.length) {
            this.writeCompressedBlock();
        }
        this.outputBuffer[this.position++] = (byte)(singleByte & BYTE_MASK);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        int inputCursor = offset;
        int remainingBytes = length;
        while (remainingBytes > 0) {
            if (this.position >= this.outputBuffer.length) {
                this.writeCompressedBlock();
            }
            int chunkLength = remainingBytes > this.outputBuffer.length - this.position ? this.outputBuffer.length - this.position : remainingBytes;
            System.arraycopy(buffer, inputCursor, this.outputBuffer, this.position, chunkLength);
            this.position += chunkLength;
            remainingBytes -= chunkLength;
            inputCursor += chunkLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        try {
            this.writeCompressedBlock();
        }
        finally {
            this.outputStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            this.outputStream.close();
        }
    }

    private void writeCompressedBlock() throws IOException {
        if (this.position > 0) {
            this.encoder.encodeChunk(this.outputStream, this.outputBuffer, 0, this.position);
            this.position = 0;
        }
    }
}

