/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Guice;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.Modules;
import org.elasticsearch.common.inject.SpawnModules;

public class ModulesBuilder
implements Iterable<Module> {
    private final List<Module> modules = Lists.newArrayList();

    public ModulesBuilder add(Module ... modules) {
        for (Module module : modules) {
            this.add(module);
        }
        return this;
    }

    public ModulesBuilder add(Module module) {
        this.modules.add(module);
        if (module instanceof SpawnModules) {
            Iterable<? extends Module> spawned = ((SpawnModules)((Object)module)).spawnModules();
            for (Module module2 : spawned) {
                this.add(module2);
            }
        }
        return this;
    }

    @Override
    public Iterator<Module> iterator() {
        return this.modules.iterator();
    }

    public Injector createInjector() {
        Modules.processModules(this.modules);
        return Guice.createInjector(this.modules);
    }

    public Injector createChildInjector(Injector injector) {
        Modules.processModules(this.modules);
        return injector.createChildInjector(this.modules);
    }
}

