/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.joda.time.format;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import org.elasticsearch.common.joda.time.Chronology;
import org.elasticsearch.common.joda.time.DateTime;
import org.elasticsearch.common.joda.time.DateTimeUtils;
import org.elasticsearch.common.joda.time.DateTimeZone;
import org.elasticsearch.common.joda.time.MutableDateTime;
import org.elasticsearch.common.joda.time.ReadWritableInstant;
import org.elasticsearch.common.joda.time.ReadableInstant;
import org.elasticsearch.common.joda.time.ReadablePartial;
import org.elasticsearch.common.joda.time.format.DateTimeParser;
import org.elasticsearch.common.joda.time.format.DateTimeParserBucket;
import org.elasticsearch.common.joda.time.format.DateTimePrinter;
import org.elasticsearch.common.joda.time.format.FormatUtils;

public class DateTimeFormatter {
    private final DateTimePrinter iPrinter;
    private final DateTimeParser iParser;
    private final Locale iLocale;
    private final boolean iOffsetParsed;
    private final Chronology iChrono;
    private final DateTimeZone iZone;
    private final Integer iPivotYear;

    public DateTimeFormatter(DateTimePrinter dateTimePrinter, DateTimeParser dateTimeParser) {
        this.iPrinter = dateTimePrinter;
        this.iParser = dateTimeParser;
        this.iLocale = null;
        this.iOffsetParsed = false;
        this.iChrono = null;
        this.iZone = null;
        this.iPivotYear = null;
    }

    private DateTimeFormatter(DateTimePrinter dateTimePrinter, DateTimeParser dateTimeParser, Locale locale, boolean bl, Chronology chronology, DateTimeZone dateTimeZone, Integer n) {
        this.iPrinter = dateTimePrinter;
        this.iParser = dateTimeParser;
        this.iLocale = locale;
        this.iOffsetParsed = bl;
        this.iChrono = chronology;
        this.iZone = dateTimeZone;
        this.iPivotYear = n;
    }

    public boolean isPrinter() {
        return this.iPrinter != null;
    }

    public DateTimePrinter getPrinter() {
        return this.iPrinter;
    }

    public boolean isParser() {
        return this.iParser != null;
    }

    public DateTimeParser getParser() {
        return this.iParser;
    }

    public DateTimeFormatter withLocale(Locale locale) {
        if (locale == this.getLocale() || locale != null && locale.equals(this.getLocale())) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, locale, this.iOffsetParsed, this.iChrono, this.iZone, this.iPivotYear);
    }

    public Locale getLocale() {
        return this.iLocale;
    }

    public DateTimeFormatter withOffsetParsed() {
        if (this.iOffsetParsed) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, this.iLocale, true, this.iChrono, null, this.iPivotYear);
    }

    public boolean isOffsetParsed() {
        return this.iOffsetParsed;
    }

    public DateTimeFormatter withChronology(Chronology chronology) {
        if (this.iChrono == chronology) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, this.iLocale, this.iOffsetParsed, chronology, this.iZone, this.iPivotYear);
    }

    public Chronology getChronology() {
        return this.iChrono;
    }

    public Chronology getChronolgy() {
        return this.iChrono;
    }

    public DateTimeFormatter withZone(DateTimeZone dateTimeZone) {
        if (this.iZone == dateTimeZone) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, this.iLocale, false, this.iChrono, dateTimeZone, this.iPivotYear);
    }

    public DateTimeZone getZone() {
        return this.iZone;
    }

    public DateTimeFormatter withPivotYear(Integer n) {
        if (this.iPivotYear == n || this.iPivotYear != null && this.iPivotYear.equals(n)) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, this.iLocale, this.iOffsetParsed, this.iChrono, this.iZone, n);
    }

    public DateTimeFormatter withPivotYear(int n) {
        return this.withPivotYear(new Integer(n));
    }

    public Integer getPivotYear() {
        return this.iPivotYear;
    }

    public void printTo(StringBuffer stringBuffer, ReadableInstant readableInstant) {
        long l = DateTimeUtils.getInstantMillis(readableInstant);
        Chronology chronology = DateTimeUtils.getInstantChronology(readableInstant);
        this.printTo(stringBuffer, l, chronology);
    }

    public void printTo(Writer writer, ReadableInstant readableInstant) throws IOException {
        long l = DateTimeUtils.getInstantMillis(readableInstant);
        Chronology chronology = DateTimeUtils.getInstantChronology(readableInstant);
        this.printTo(writer, l, chronology);
    }

    public void printTo(StringBuffer stringBuffer, long l) {
        this.printTo(stringBuffer, l, null);
    }

    public void printTo(Writer writer, long l) throws IOException {
        this.printTo(writer, l, null);
    }

    public void printTo(StringBuffer stringBuffer, ReadablePartial readablePartial) {
        DateTimePrinter dateTimePrinter = this.requirePrinter();
        if (readablePartial == null) {
            throw new IllegalArgumentException("The partial must not be null");
        }
        dateTimePrinter.printTo(stringBuffer, readablePartial, this.iLocale);
    }

    public void printTo(Writer writer, ReadablePartial readablePartial) throws IOException {
        DateTimePrinter dateTimePrinter = this.requirePrinter();
        if (readablePartial == null) {
            throw new IllegalArgumentException("The partial must not be null");
        }
        dateTimePrinter.printTo(writer, readablePartial, this.iLocale);
    }

    public String print(ReadableInstant readableInstant) {
        StringBuffer stringBuffer = new StringBuffer(this.requirePrinter().estimatePrintedLength());
        this.printTo(stringBuffer, readableInstant);
        return stringBuffer.toString();
    }

    public String print(long l) {
        StringBuffer stringBuffer = new StringBuffer(this.requirePrinter().estimatePrintedLength());
        this.printTo(stringBuffer, l);
        return stringBuffer.toString();
    }

    public String print(ReadablePartial readablePartial) {
        StringBuffer stringBuffer = new StringBuffer(this.requirePrinter().estimatePrintedLength());
        this.printTo(stringBuffer, readablePartial);
        return stringBuffer.toString();
    }

    private void printTo(StringBuffer stringBuffer, long l, Chronology chronology) {
        DateTimePrinter dateTimePrinter = this.requirePrinter();
        DateTimeZone dateTimeZone = (chronology = this.selectChronology(chronology)).getZone();
        int n = dateTimeZone.getOffset(l);
        long l2 = l + (long)n;
        if ((l ^ l2) < 0L && (l ^ (long)n) >= 0L) {
            dateTimeZone = DateTimeZone.UTC;
            n = 0;
            l2 = l;
        }
        dateTimePrinter.printTo(stringBuffer, l2, chronology.withUTC(), n, dateTimeZone, this.iLocale);
    }

    private void printTo(Writer writer, long l, Chronology chronology) throws IOException {
        DateTimePrinter dateTimePrinter = this.requirePrinter();
        DateTimeZone dateTimeZone = (chronology = this.selectChronology(chronology)).getZone();
        int n = dateTimeZone.getOffset(l);
        long l2 = l + (long)n;
        if ((l ^ l2) < 0L && (l ^ (long)n) >= 0L) {
            dateTimeZone = DateTimeZone.UTC;
            n = 0;
            l2 = l;
        }
        dateTimePrinter.printTo(writer, l2, chronology.withUTC(), n, dateTimeZone, this.iLocale);
    }

    private DateTimePrinter requirePrinter() {
        DateTimePrinter dateTimePrinter = this.iPrinter;
        if (dateTimePrinter == null) {
            throw new UnsupportedOperationException("Printing not supported");
        }
        return dateTimePrinter;
    }

    public int parseInto(ReadWritableInstant readWritableInstant, String string, int n) {
        DateTimeParser dateTimeParser = this.requireParser();
        if (readWritableInstant == null) {
            throw new IllegalArgumentException("Instant must not be null");
        }
        long l = readWritableInstant.getMillis();
        Chronology chronology = readWritableInstant.getChronology();
        long l2 = l + (long)chronology.getZone().getOffset(l);
        chronology = this.selectChronology(chronology);
        DateTimeParserBucket dateTimeParserBucket = new DateTimeParserBucket(l2, chronology, this.iLocale, this.iPivotYear);
        int n2 = dateTimeParser.parseInto(dateTimeParserBucket, string, n);
        readWritableInstant.setMillis(dateTimeParserBucket.computeMillis(false, string));
        if (this.iOffsetParsed && dateTimeParserBucket.getZone() == null) {
            int n3 = dateTimeParserBucket.getOffset();
            DateTimeZone dateTimeZone = DateTimeZone.forOffsetMillis(n3);
            chronology = chronology.withZone(dateTimeZone);
        }
        readWritableInstant.setChronology(chronology);
        return n2;
    }

    public long parseMillis(String string) {
        Chronology chronology;
        DateTimeParserBucket dateTimeParserBucket;
        DateTimeParser dateTimeParser = this.requireParser();
        int n = dateTimeParser.parseInto(dateTimeParserBucket = new DateTimeParserBucket(0L, chronology = this.selectChronology(this.iChrono), this.iLocale, this.iPivotYear), string, 0);
        if (n >= 0) {
            if (n >= string.length()) {
                return dateTimeParserBucket.computeMillis(true, string);
            }
        } else {
            n ^= 0xFFFFFFFF;
        }
        throw new IllegalArgumentException(FormatUtils.createErrorMessage(string, n));
    }

    public DateTime parseDateTime(String string) {
        Chronology chronology;
        DateTimeParserBucket dateTimeParserBucket;
        DateTimeParser dateTimeParser = this.requireParser();
        int n = dateTimeParser.parseInto(dateTimeParserBucket = new DateTimeParserBucket(0L, chronology = this.selectChronology(null), this.iLocale, this.iPivotYear), string, 0);
        if (n >= 0) {
            if (n >= string.length()) {
                long l = dateTimeParserBucket.computeMillis(true, string);
                if (this.iOffsetParsed && dateTimeParserBucket.getZone() == null) {
                    int n2 = dateTimeParserBucket.getOffset();
                    DateTimeZone dateTimeZone = DateTimeZone.forOffsetMillis(n2);
                    chronology = chronology.withZone(dateTimeZone);
                }
                return new DateTime(l, chronology);
            }
        } else {
            n ^= 0xFFFFFFFF;
        }
        throw new IllegalArgumentException(FormatUtils.createErrorMessage(string, n));
    }

    public MutableDateTime parseMutableDateTime(String string) {
        Chronology chronology;
        DateTimeParserBucket dateTimeParserBucket;
        DateTimeParser dateTimeParser = this.requireParser();
        int n = dateTimeParser.parseInto(dateTimeParserBucket = new DateTimeParserBucket(0L, chronology = this.selectChronology(null), this.iLocale, this.iPivotYear), string, 0);
        if (n >= 0) {
            if (n >= string.length()) {
                long l = dateTimeParserBucket.computeMillis(true, string);
                if (this.iOffsetParsed && dateTimeParserBucket.getZone() == null) {
                    int n2 = dateTimeParserBucket.getOffset();
                    DateTimeZone dateTimeZone = DateTimeZone.forOffsetMillis(n2);
                    chronology = chronology.withZone(dateTimeZone);
                }
                return new MutableDateTime(l, chronology);
            }
        } else {
            n ^= 0xFFFFFFFF;
        }
        throw new IllegalArgumentException(FormatUtils.createErrorMessage(string, n));
    }

    private DateTimeParser requireParser() {
        DateTimeParser dateTimeParser = this.iParser;
        if (dateTimeParser == null) {
            throw new UnsupportedOperationException("Parsing not supported");
        }
        return dateTimeParser;
    }

    private Chronology selectChronology(Chronology chronology) {
        chronology = DateTimeUtils.getChronology(chronology);
        if (this.iChrono != null) {
            chronology = this.iChrono;
        }
        if (this.iZone != null) {
            chronology = chronology.withZone(this.iZone);
        }
        return chronology;
    }
}

