/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.store;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.index.store.support.ForceSyncDirectory;

public class SwitchDirectory
extends Directory
implements ForceSyncDirectory {
    private final Directory secondaryDir;
    private final Directory primaryDir;
    private final ImmutableSet<String> primaryExtensions;
    private boolean doClose;

    public SwitchDirectory(Set<String> primaryExtensions, Directory primaryDir, Directory secondaryDir, boolean doClose) {
        this.primaryExtensions = ImmutableSet.copyOf(primaryExtensions);
        this.primaryDir = primaryDir;
        this.secondaryDir = secondaryDir;
        this.doClose = doClose;
        this.lockFactory = primaryDir.getLockFactory();
    }

    public ImmutableSet<String> primaryExtensions() {
        return this.primaryExtensions;
    }

    public Directory primaryDir() {
        return this.primaryDir;
    }

    public Directory secondaryDir() {
        return this.secondaryDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.doClose) {
            try {
                this.secondaryDir.close();
            }
            finally {
                this.primaryDir.close();
            }
            this.doClose = false;
        }
    }

    public String[] listAll() throws IOException {
        HashSet<String> files = new HashSet<String>();
        for (String f : this.primaryDir.listAll()) {
            files.add(f);
        }
        for (String f : this.secondaryDir.listAll()) {
            files.add(f);
        }
        return files.toArray(new String[files.size()]);
    }

    public static String getExtension(String name) {
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return name.substring(i + 1, name.length());
    }

    private Directory getDirectory(String name) {
        String ext = SwitchDirectory.getExtension(name);
        if (this.primaryExtensions.contains(ext)) {
            return this.primaryDir;
        }
        return this.secondaryDir;
    }

    public boolean fileExists(String name) throws IOException {
        return this.getDirectory(name).fileExists(name);
    }

    public long fileModified(String name) throws IOException {
        return this.getDirectory(name).fileModified(name);
    }

    public void touchFile(String name) throws IOException {
        this.getDirectory(name).touchFile(name);
    }

    public void deleteFile(String name) throws IOException {
        this.getDirectory(name).deleteFile(name);
    }

    public long fileLength(String name) throws IOException {
        return this.getDirectory(name).fileLength(name);
    }

    public IndexOutput createOutput(String name) throws IOException {
        return this.getDirectory(name).createOutput(name);
    }

    public void sync(String name) throws IOException {
        this.getDirectory(name).sync(name);
    }

    @Override
    public void forceSync(String name) throws IOException {
        Directory dir = this.getDirectory(name);
        if (dir instanceof ForceSyncDirectory) {
            ((ForceSyncDirectory)dir).forceSync(name);
        } else {
            dir.sync(name);
        }
    }

    public IndexInput openInput(String name) throws IOException {
        return this.getDirectory(name).openInput(name);
    }
}

