/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.channel.socket.oio;

import java.util.concurrent.Executor;
import org.elasticsearch.common.netty.channel.ChannelPipeline;
import org.elasticsearch.common.netty.channel.socket.ClientSocketChannelFactory;
import org.elasticsearch.common.netty.channel.socket.SocketChannel;
import org.elasticsearch.common.netty.channel.socket.oio.OioClientSocketChannel;
import org.elasticsearch.common.netty.channel.socket.oio.OioClientSocketPipelineSink;
import org.elasticsearch.common.netty.util.internal.ExecutorUtil;

public class OioClientSocketChannelFactory
implements ClientSocketChannelFactory {
    private final Executor workerExecutor;
    final OioClientSocketPipelineSink sink;

    public OioClientSocketChannelFactory(Executor workerExecutor) {
        if (workerExecutor == null) {
            throw new NullPointerException("workerExecutor");
        }
        this.workerExecutor = workerExecutor;
        this.sink = new OioClientSocketPipelineSink(workerExecutor);
    }

    public SocketChannel newChannel(ChannelPipeline pipeline) {
        return new OioClientSocketChannel(this, pipeline, this.sink);
    }

    public void releaseExternalResources() {
        ExecutorUtil.terminate(this.workerExecutor);
    }
}

