/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.handler.execution;

import java.util.concurrent.Executor;
import org.elasticsearch.common.netty.channel.ChannelDownstreamHandler;
import org.elasticsearch.common.netty.channel.ChannelEvent;
import org.elasticsearch.common.netty.channel.ChannelHandler;
import org.elasticsearch.common.netty.channel.ChannelHandlerContext;
import org.elasticsearch.common.netty.channel.ChannelState;
import org.elasticsearch.common.netty.channel.ChannelStateEvent;
import org.elasticsearch.common.netty.channel.ChannelUpstreamHandler;
import org.elasticsearch.common.netty.handler.execution.ChannelEventRunnable;
import org.elasticsearch.common.netty.util.ExternalResourceReleasable;
import org.elasticsearch.common.netty.util.internal.ExecutorUtil;

@ChannelHandler.Sharable
public class ExecutionHandler
implements ChannelUpstreamHandler,
ChannelDownstreamHandler,
ExternalResourceReleasable {
    private final Executor executor;

    public ExecutionHandler(Executor executor) {
        if (executor == null) {
            throw new NullPointerException("executor");
        }
        this.executor = executor;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void releaseExternalResources() {
        ExecutorUtil.terminate(this.getExecutor());
    }

    public void handleUpstream(ChannelHandlerContext context, ChannelEvent e) throws Exception {
        this.executor.execute(new ChannelEventRunnable(context, e));
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        ChannelStateEvent cse;
        if (e instanceof ChannelStateEvent && (cse = (ChannelStateEvent)e).getState() == ChannelState.INTEREST_OPS && ((Integer)cse.getValue() & 1) != 0) {
            boolean readSuspended;
            boolean bl = readSuspended = ctx.getAttachment() != null;
            if (readSuspended) {
                e.getFuture().setSuccess();
                return;
            }
        }
        ctx.sendDownstream(e);
    }
}

