/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentGenerator;
import org.elasticsearch.common.xcontent.XContentParser;

public class XContentMapConverter {
    public static Map<String, Object> readMap(XContentParser parser) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        XContentParser.Token t = parser.currentToken();
        if (t == null) {
            t = parser.nextToken();
        }
        if (t == XContentParser.Token.START_OBJECT) {
            t = parser.nextToken();
        }
        while (t == XContentParser.Token.FIELD_NAME) {
            String fieldName = parser.currentName();
            t = parser.nextToken();
            Object value = XContentMapConverter.readValue(parser, t);
            map.put(fieldName, value);
            t = parser.nextToken();
        }
        return map;
    }

    private static List<Object> readList(XContentParser parser, XContentParser.Token t) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        while ((t = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            list.add(XContentMapConverter.readValue(parser, t));
        }
        return list;
    }

    private static Object readValue(XContentParser parser, XContentParser.Token t) throws IOException {
        if (t == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        if (t == XContentParser.Token.VALUE_STRING) {
            return parser.text();
        }
        if (t == XContentParser.Token.VALUE_NUMBER) {
            XContentParser.NumberType numberType = parser.numberType();
            if (numberType == XContentParser.NumberType.INT) {
                return parser.intValue();
            }
            if (numberType == XContentParser.NumberType.LONG) {
                return parser.longValue();
            }
            if (numberType == XContentParser.NumberType.FLOAT) {
                return Float.valueOf(parser.floatValue());
            }
            if (numberType == XContentParser.NumberType.DOUBLE) {
                return parser.doubleValue();
            }
        } else {
            if (t == XContentParser.Token.VALUE_BOOLEAN) {
                return parser.booleanValue();
            }
            if (t == XContentParser.Token.START_OBJECT) {
                return XContentMapConverter.readMap(parser);
            }
            if (t == XContentParser.Token.START_ARRAY) {
                return XContentMapConverter.readList(parser, t);
            }
        }
        return null;
    }

    public static void writeMap(XContentGenerator gen, Map<String, Object> map) throws IOException {
        gen.writeStartObject();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            gen.writeFieldName(entry.getKey());
            Object value = entry.getValue();
            if (value == null) {
                gen.writeNull();
                continue;
            }
            XContentMapConverter.writeValue(gen, value);
        }
        gen.writeEndObject();
    }

    private static void writeIterable(XContentGenerator gen, Iterable iterable) throws IOException {
        gen.writeStartArray();
        for (Object value : iterable) {
            XContentMapConverter.writeValue(gen, value);
        }
        gen.writeEndArray();
    }

    private static void writeObjectArray(XContentGenerator gen, Object[] array) throws IOException {
        gen.writeStartArray();
        for (Object value : array) {
            XContentMapConverter.writeValue(gen, value);
        }
        gen.writeEndArray();
    }

    private static void writeValue(XContentGenerator gen, Object value) throws IOException {
        Class<?> type = value.getClass();
        if (type == String.class) {
            gen.writeString((String)value);
        } else if (type == Integer.class) {
            gen.writeNumber((Integer)value);
        } else if (type == Long.class) {
            gen.writeNumber((Long)value);
        } else if (type == Float.class) {
            gen.writeNumber(((Float)value).floatValue());
        } else if (type == Double.class) {
            gen.writeNumber((Double)value);
        } else if (type == Short.class) {
            gen.writeNumber(((Short)value).shortValue());
        } else if (type == Boolean.class) {
            gen.writeBoolean((Boolean)value);
        } else if (value instanceof Map) {
            XContentMapConverter.writeMap(gen, (Map)value);
        } else if (value instanceof Iterable) {
            XContentMapConverter.writeIterable(gen, (Iterable)value);
        } else if (value instanceof Object[]) {
            XContentMapConverter.writeObjectArray(gen, (Object[])value);
        } else if (type == byte[].class) {
            gen.writeBinary((byte[])value);
        } else if (type == Date.class) {
            gen.writeString(XContentBuilder.defaultDatePrinter.print(((Date)value).getTime()));
        } else if (type == java.sql.Date.class) {
            gen.writeString(XContentBuilder.defaultDatePrinter.print(((java.sql.Date)value).getTime()));
        } else {
            gen.writeString(value.toString());
        }
    }
}

