/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway.local;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.support.nodes.NodesOperationResponse;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.allocation.FailedRerouteAllocation;
import org.elasticsearch.cluster.routing.allocation.NodeAllocation;
import org.elasticsearch.cluster.routing.allocation.NodeAllocations;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.StartedRerouteAllocation;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.gateway.local.TransportNodesListGatewayStartedShards;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.indices.store.TransportNodesListShardStoreMetaData;
import org.elasticsearch.transport.ConnectTransportException;

public class LocalGatewayNodeAllocation
extends NodeAllocation {
    private final TransportNodesListGatewayStartedShards listGatewayStartedShards;
    private final TransportNodesListShardStoreMetaData listShardStoreMetaData;
    private final ConcurrentMap<ShardId, ConcurrentMap<DiscoveryNode, TransportNodesListShardStoreMetaData.StoreFilesMetaData>> cachedStores = ConcurrentCollections.newConcurrentMap();
    private final TimeValue listTimeout;
    private final String initialShards;

    @Inject
    public LocalGatewayNodeAllocation(Settings settings, TransportNodesListGatewayStartedShards listGatewayStartedShards, TransportNodesListShardStoreMetaData listShardStoreMetaData) {
        super(settings);
        this.listGatewayStartedShards = listGatewayStartedShards;
        this.listShardStoreMetaData = listShardStoreMetaData;
        this.listTimeout = this.componentSettings.getAsTime("list_timeout", TimeValue.timeValueSeconds(30L));
        this.initialShards = this.componentSettings.get("initial_shards", "quorum");
    }

    @Override
    public void applyStartedShards(NodeAllocations nodeAllocations, StartedRerouteAllocation allocation) {
        for (ShardRouting shardRouting : allocation.startedShards()) {
            this.cachedStores.remove(shardRouting.shardId());
        }
    }

    @Override
    public void applyFailedShards(NodeAllocations nodeAllocations, FailedRerouteAllocation allocation) {
        for (ShardRouting shardRouting : allocation.failedShards()) {
            this.cachedStores.remove(shardRouting.shardId());
        }
        NodesOperationResponse nodesState = null;
        for (ShardRouting shardRouting : allocation.failedShards()) {
            RoutingNode currentRoutingNode;
            if (!allocation.routingNodes().routingTable().index(shardRouting.index()).shard(shardRouting.id()).allocatedPostApi()) continue;
            if (nodesState == null) {
                HashSet<String> nodesIds = Sets.newHashSet();
                nodesIds.addAll(allocation.nodes().dataNodes().keySet());
                nodesState = this.listGatewayStartedShards.list(nodesIds, null).actionGet();
                if (((TransportNodesListGatewayStartedShards.NodesLocalGatewayStartedShards)nodesState).failures().length > 0) {
                    StringBuilder sb = new StringBuilder("failures when trying to list started shards on nodes:");
                    for (int i = 0; i < ((TransportNodesListGatewayStartedShards.NodesLocalGatewayStartedShards)nodesState).failures().length; ++i) {
                        Throwable cause = ExceptionsHelper.unwrapCause(((TransportNodesListGatewayStartedShards.NodesLocalGatewayStartedShards)nodesState).failures()[i]);
                        if (cause instanceof ConnectTransportException) continue;
                        sb.append("\n    -> ").append(((TransportNodesListGatewayStartedShards.NodesLocalGatewayStartedShards)nodesState).failures()[i].getDetailedMessage());
                    }
                    this.logger.warn(sb.toString(), new Object[0]);
                }
            }
            Tuple t = null;
            for (TransportNodesListGatewayStartedShards.NodeLocalGatewayStartedShards nodeState : nodesState) {
                if (nodeState.state() == null || nodeState.node().id().equals(shardRouting.currentNodeId())) continue;
                for (Map.Entry entry : nodeState.state().shards().entrySet()) {
                    if (!((ShardId)entry.getKey()).equals(shardRouting.shardId()) || t != null && (Long)entry.getValue() <= (Long)t.v2()) continue;
                    t = new Tuple(nodeState.node(), entry.getValue());
                }
            }
            if (t == null || (currentRoutingNode = allocation.routingNodes().nodesToShards().get(shardRouting.currentNodeId())) == null) continue;
            Iterator<MutableShardRouting> shards = currentRoutingNode.iterator();
            while (shards.hasNext()) {
                MutableShardRouting shard = shards.next();
                if (!shard.shardId().equals(shardRouting.shardId())) continue;
                shard.deassignNode();
                shards.remove();
                break;
            }
            RoutingNode targetNode = allocation.routingNodes().nodesToShards().get(((DiscoveryNode)t.v1()).id());
            targetNode.add(new MutableShardRouting(shardRouting.index(), shardRouting.id(), targetNode.nodeId(), shardRouting.relocatingNodeId(), shardRouting.primary(), ShardRoutingState.INITIALIZING));
        }
    }

    @Override
    public boolean allocateUnassigned(NodeAllocations nodeAllocations, RoutingAllocation allocation) {
        MutableShardRouting shard;
        boolean changed = false;
        DiscoveryNodes nodes = allocation.nodes();
        RoutingNodes routingNodes = allocation.routingNodes();
        NodesOperationResponse nodesState = null;
        Iterator<MutableShardRouting> unassignedIterator = routingNodes.unassigned().iterator();
        while (unassignedIterator.hasNext()) {
            shard = unassignedIterator.next();
            if (!shard.primary() || !routingNodes.routingTable().index(shard.index()).shard(shard.id()).allocatedPostApi()) continue;
            if (nodesState == null) {
                HashSet<String> nodesIds = Sets.newHashSet();
                nodesIds.addAll(nodes.dataNodes().keySet());
                nodesState = this.listGatewayStartedShards.list(nodesIds, null).actionGet();
                if (((TransportNodesListGatewayStartedShards.NodesLocalGatewayStartedShards)nodesState).failures().length > 0) {
                    StringBuilder sb = new StringBuilder("failures when trying to list started shards on nodes:");
                    for (int i = 0; i < ((TransportNodesListGatewayStartedShards.NodesLocalGatewayStartedShards)nodesState).failures().length; ++i) {
                        Throwable cause = ExceptionsHelper.unwrapCause(((TransportNodesListGatewayStartedShards.NodesLocalGatewayStartedShards)nodesState).failures()[i]);
                        if (cause instanceof ConnectTransportException) continue;
                        sb.append("\n    -> ").append(((TransportNodesListGatewayStartedShards.NodesLocalGatewayStartedShards)nodesState).failures()[i].getDetailedMessage());
                    }
                    this.logger.warn(sb.toString(), new Object[0]);
                }
            }
            int numberOfAllocationsFound = 0;
            long highestVersion = -1L;
            DiscoveryNode nodeWithHighestVersion = null;
            for (TransportNodesListGatewayStartedShards.NodeLocalGatewayStartedShards nodeState : nodesState) {
                Long version;
                if (nodeState.state() == null || (version = nodeState.state().shards().get(shard.shardId())) == null) continue;
                ++numberOfAllocationsFound;
                if (highestVersion == -1L) {
                    nodeWithHighestVersion = nodeState.node();
                    highestVersion = version;
                    continue;
                }
                if (version <= highestVersion) continue;
                nodeWithHighestVersion = nodeState.node();
                highestVersion = version;
            }
            int requiredAllocation = 1;
            IndexMetaData indexMetaData = routingNodes.metaData().index(shard.index());
            if ("quorum".equals(this.initialShards)) {
                if (indexMetaData.numberOfReplicas() > 1) {
                    requiredAllocation = (1 + indexMetaData.numberOfReplicas()) / 2 + 1;
                }
            } else if ("full".equals(this.initialShards)) {
                requiredAllocation = indexMetaData.numberOfReplicas() + 1;
            } else if ("full-1".equals(this.initialShards)) {
                if (indexMetaData.numberOfReplicas() > 1) {
                    requiredAllocation = indexMetaData.numberOfReplicas();
                }
            } else {
                requiredAllocation = Integer.parseInt(this.initialShards);
            }
            if (numberOfAllocationsFound < requiredAllocation) {
                unassignedIterator.remove();
                routingNodes.ignoredUnassigned().add(shard);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("[{}][{}]: not allocating, number_of_allocated_shards_found [{}], required_number [{}]", shard.index(), shard.id(), numberOfAllocationsFound, requiredAllocation);
                continue;
            }
            RoutingNode node = routingNodes.node(nodeWithHighestVersion.id());
            if (nodeAllocations.canAllocate(shard, node, allocation) == NodeAllocation.Decision.THROTTLE) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("[{}][{}]: throttling allocation [{}] to [{}] on primary allocation", shard.index(), shard.id(), shard, nodeWithHighestVersion);
                }
                unassignedIterator.remove();
                routingNodes.ignoredUnassigned().add(shard);
                continue;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[{}][{}]: allocating [{}] to [{}] on primary allocation", shard.index(), shard.id(), shard, nodeWithHighestVersion);
            }
            changed = true;
            node.add(shard);
            unassignedIterator.remove();
        }
        if (!routingNodes.hasUnassigned()) {
            return changed;
        }
        unassignedIterator = routingNodes.unassigned().iterator();
        while (unassignedIterator.hasNext()) {
            shard = unassignedIterator.next();
            boolean canBeAllocatedToAtLeastOneNode = false;
            for (DiscoveryNode discoNode : nodes.dataNodes().values()) {
                RoutingNode node = routingNodes.node(discoNode.id());
                if (node == null || !nodeAllocations.canAllocate(shard, node, allocation).allocate()) continue;
                canBeAllocatedToAtLeastOneNode = true;
                break;
            }
            if (!canBeAllocatedToAtLeastOneNode) continue;
            ConcurrentMap<DiscoveryNode, TransportNodesListShardStoreMetaData.StoreFilesMetaData> shardStores = this.buildShardStores(nodes, shard);
            long lastSizeMatched = 0L;
            DiscoveryNode lastDiscoNodeMatched = null;
            RoutingNode lastNodeMatched = null;
            for (Map.Entry nodeStoreEntry : shardStores.entrySet()) {
                TransportNodesListShardStoreMetaData.StoreFilesMetaData primaryNodeStore;
                DiscoveryNode primaryNode;
                MutableShardRouting primaryShard;
                RoutingNode node;
                DiscoveryNode discoNode = (DiscoveryNode)nodeStoreEntry.getKey();
                TransportNodesListShardStoreMetaData.StoreFilesMetaData storeFilesMetaData = (TransportNodesListShardStoreMetaData.StoreFilesMetaData)nodeStoreEntry.getValue();
                this.logger.trace("{}: checking node [{}]", shard, discoNode);
                if (storeFilesMetaData == null || (node = routingNodes.node(discoNode.id())) == null || nodeAllocations.canAllocate(shard, node, allocation) == NodeAllocation.Decision.NO || storeFilesMetaData.allocated() || shard.primary() || (primaryShard = routingNodes.findPrimaryForReplica(shard)) == null || !primaryShard.active() || (primaryNode = nodes.get(primaryShard.currentNodeId())) == null || (primaryNodeStore = (TransportNodesListShardStoreMetaData.StoreFilesMetaData)shardStores.get(primaryNode)) == null || !primaryNodeStore.allocated()) continue;
                long sizeMatched = 0L;
                for (StoreFileMetaData storeFileMetaData : storeFilesMetaData) {
                    if (!primaryNodeStore.fileExists(storeFileMetaData.name()) || !primaryNodeStore.file(storeFileMetaData.name()).isSame(storeFileMetaData)) continue;
                    sizeMatched += storeFileMetaData.length();
                }
                if (sizeMatched <= lastSizeMatched) continue;
                lastSizeMatched = sizeMatched;
                lastDiscoNodeMatched = discoNode;
                lastNodeMatched = node;
            }
            if (lastNodeMatched == null) continue;
            if (nodeAllocations.canAllocate(shard, lastNodeMatched, allocation) == NodeAllocation.Decision.THROTTLE) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.debug("[{}][{}]: throttling allocation [{}] to [{}] in order to reuse its unallocated persistent store with total_size [{}]", shard.index(), shard.id(), shard, lastDiscoNodeMatched, new ByteSizeValue(lastSizeMatched));
                }
                unassignedIterator.remove();
                routingNodes.ignoredUnassigned().add(shard);
                continue;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[{}][{}]: allocating [{}] to [{}] in order to reuse its unallocated persistent store with total_size [{}]", shard.index(), shard.id(), shard, lastDiscoNodeMatched, new ByteSizeValue(lastSizeMatched));
            }
            changed = true;
            lastNodeMatched.add(shard);
            unassignedIterator.remove();
        }
        return changed;
    }

    private ConcurrentMap<DiscoveryNode, TransportNodesListShardStoreMetaData.StoreFilesMetaData> buildShardStores(DiscoveryNodes nodes, MutableShardRouting shard) {
        ConcurrentMap<DiscoveryNode, TransportNodesListShardStoreMetaData.StoreFilesMetaData> shardStores = (ConcurrentMap<DiscoveryNode, TransportNodesListShardStoreMetaData.StoreFilesMetaData>)this.cachedStores.get(shard.shardId());
        if (shardStores == null) {
            shardStores = ConcurrentCollections.newConcurrentMap();
            TransportNodesListShardStoreMetaData.NodesStoreFilesMetaData nodesStoreFilesMetaData = this.listShardStoreMetaData.list(shard.shardId(), false, nodes.dataNodes().keySet(), this.listTimeout).actionGet();
            if (this.logger.isDebugEnabled() && nodesStoreFilesMetaData.failures().length > 0) {
                StringBuilder sb = new StringBuilder(shard + ": failures when trying to list stores on nodes:");
                for (int i = 0; i < nodesStoreFilesMetaData.failures().length; ++i) {
                    Throwable cause = ExceptionsHelper.unwrapCause(nodesStoreFilesMetaData.failures()[i]);
                    if (cause instanceof ConnectTransportException) continue;
                    sb.append("\n    -> ").append(nodesStoreFilesMetaData.failures()[i].getDetailedMessage());
                }
                this.logger.debug(sb.toString(), new Object[0]);
            }
            for (TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData nodeStoreFilesMetaData : nodesStoreFilesMetaData) {
                if (nodeStoreFilesMetaData.storeFilesMetaData() == null) continue;
                shardStores.put(nodeStoreFilesMetaData.node(), nodeStoreFilesMetaData.storeFilesMetaData());
            }
            this.cachedStores.put(shard.shardId(), shardStores);
        } else {
            for (DiscoveryNode node : shardStores.keySet()) {
                if (nodes.nodeExists(node.id())) continue;
                shardStores.remove(node);
            }
            HashSet<String> fetchedNodes = Sets.newHashSet();
            for (DiscoveryNode node : nodes.dataNodes().values()) {
                if (shardStores.containsKey(node)) continue;
                fetchedNodes.add(node.id());
            }
            if (!fetchedNodes.isEmpty()) {
                TransportNodesListShardStoreMetaData.NodesStoreFilesMetaData nodesStoreFilesMetaData = this.listShardStoreMetaData.list(shard.shardId(), false, fetchedNodes, this.listTimeout).actionGet();
                if (this.logger.isTraceEnabled() && nodesStoreFilesMetaData.failures().length > 0) {
                    StringBuilder sb = new StringBuilder(shard + ": failures when trying to list stores on nodes:");
                    for (int i = 0; i < nodesStoreFilesMetaData.failures().length; ++i) {
                        Throwable cause = ExceptionsHelper.unwrapCause(nodesStoreFilesMetaData.failures()[i]);
                        if (cause instanceof ConnectTransportException) continue;
                        sb.append("\n    -> ").append(nodesStoreFilesMetaData.failures()[i].getDetailedMessage());
                    }
                    this.logger.trace(sb.toString(), new Object[0]);
                }
                for (TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData nodeStoreFilesMetaData : nodesStoreFilesMetaData) {
                    if (nodeStoreFilesMetaData.storeFilesMetaData() == null) continue;
                    shardStores.put(nodeStoreFilesMetaData.node(), nodeStoreFilesMetaData.storeFilesMetaData());
                }
            }
        }
        return shardStores;
    }
}

