/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Set;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.settings.IndexSettings;

public class GermanAnalyzerProvider
extends AbstractIndexAnalyzerProvider<GermanAnalyzer> {
    private final Set<?> stemExclusion;
    private final GermanAnalyzer analyzer;

    @Inject
    public GermanAnalyzerProvider(Index index, @IndexSettings Settings indexSettings, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name);
        Set<?> stopWords = Analysis.parseStopWords(settings, GermanAnalyzer.getDefaultStopSet());
        String[] stemExclusion = settings.getAsArray("stem_exclusion");
        this.stemExclusion = stemExclusion.length > 0 ? ImmutableSet.copyOf(Iterators.forArray(stemExclusion)) : ImmutableSet.of();
        this.analyzer = new GermanAnalyzer(Lucene.ANALYZER_VERSION, stopWords, this.stemExclusion);
    }

    @Override
    public GermanAnalyzer get() {
        return this.analyzer;
    }
}

