/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis.phonetic;

import org.apache.lucene.analysis.TokenStream;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.codec.Encoder;
import org.elasticsearch.common.codec.language.Caverphone;
import org.elasticsearch.common.codec.language.DoubleMetaphone;
import org.elasticsearch.common.codec.language.Metaphone;
import org.elasticsearch.common.codec.language.RefinedSoundex;
import org.elasticsearch.common.codec.language.Soundex;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.AnalysisSettingsRequired;
import org.elasticsearch.index.analysis.phonetic.PhoneticFilter;
import org.elasticsearch.index.settings.IndexSettings;

@AnalysisSettingsRequired
public class PhoneticTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final Encoder encoder;
    private final boolean inject;

    @Inject
    public PhoneticTokenFilterFactory(Index index, @IndexSettings Settings indexSettings, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name);
        this.inject = settings.getAsBoolean("replace", true);
        String encoder = settings.get("encoder");
        if (encoder == null) {
            throw new ElasticSearchIllegalArgumentException("encoder must be set on phonetic token filter");
        }
        if ("metaphone".equalsIgnoreCase(encoder)) {
            this.encoder = new Metaphone();
        } else if ("soundex".equalsIgnoreCase(encoder)) {
            this.encoder = new Soundex();
        } else if ("caverphone".equalsIgnoreCase(encoder)) {
            this.encoder = new Caverphone();
        } else if ("refined_soundex".equalsIgnoreCase(encoder) || "refinedSoundex".equalsIgnoreCase(encoder)) {
            this.encoder = new RefinedSoundex();
        } else if ("double_metaphone".equalsIgnoreCase(encoder) || "doubleMetaphone".equalsIgnoreCase(encoder)) {
            this.encoder = new DoubleMetaphone();
        } else {
            throw new ElasticSearchIllegalArgumentException("unknown encoder [" + encoder + "] for phonetic token filter");
        }
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new PhoneticFilter(tokenStream, this.encoder, this.name(), this.inject);
    }
}

