/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.field.data.support;

import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.collect.MapMaker;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.settings.IndexSettings;

public abstract class AbstractConcurrentMapFieldDataCache
extends AbstractIndexComponent
implements FieldDataCache {
    private final ConcurrentMap<Object, ConcurrentMap<String, FieldData>> cache;
    private final Object creationMutex = new Object();

    protected AbstractConcurrentMapFieldDataCache(Index index, @IndexSettings Settings indexSettings) {
        super(index, indexSettings);
        this.cache = new MapMaker().weakKeys().makeMap();
    }

    @Override
    public void close() throws ElasticSearchException {
        this.clear();
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void clear(IndexReader reader) {
        ConcurrentMap map = (ConcurrentMap)this.cache.remove(reader.getFieldCacheKey());
        if (map != null) {
            map.clear();
        }
    }

    @Override
    public void clearUnreferenced() {
    }

    @Override
    public long sizeInBytes() {
        long sizeInBytes = 0L;
        for (ConcurrentMap map : this.cache.values()) {
            for (FieldData fieldData : map.values()) {
                sizeInBytes += fieldData.sizeInBytes();
            }
        }
        return sizeInBytes;
    }

    @Override
    public long sizeInBytes(String fieldName) {
        long sizeInBytes = 0L;
        for (ConcurrentMap map : this.cache.values()) {
            FieldData fieldData = (FieldData)map.get(fieldName);
            if (fieldData == null) continue;
            sizeInBytes += fieldData.sizeInBytes();
        }
        return sizeInBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldData cache(FieldDataType type, IndexReader reader, String fieldName) throws IOException {
        FieldData fieldData;
        ConcurrentMap<String, FieldData> fieldDataCache = (ConcurrentMap<String, FieldData>)this.cache.get(reader.getFieldCacheKey());
        if (fieldDataCache == null) {
            Object object = this.creationMutex;
            synchronized (object) {
                fieldDataCache = (ConcurrentMap)this.cache.get(reader.getFieldCacheKey());
                if (fieldDataCache == null) {
                    fieldDataCache = this.buildFieldDataMap();
                    this.cache.put(reader.getFieldCacheKey(), fieldDataCache);
                }
            }
        }
        if ((fieldData = (FieldData)fieldDataCache.get(fieldName)) == null) {
            ConcurrentMap<String, FieldData> concurrentMap = fieldDataCache;
            synchronized (concurrentMap) {
                fieldData = (FieldData)fieldDataCache.get(fieldName);
                if (fieldData == null) {
                    fieldData = FieldData.load(type, reader, fieldName);
                    fieldDataCache.put(fieldName, fieldData);
                }
            }
        }
        return fieldData;
    }

    protected ConcurrentMap<String, FieldData> buildFieldDataMap() {
        return ConcurrentCollections.newConcurrentMap();
    }
}

