/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.xcontent;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.FieldMapperListener;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.xcontent.MergeContext;
import org.elasticsearch.index.mapper.xcontent.ParseContext;
import org.elasticsearch.index.mapper.xcontent.XContentMapper;

public class AnalyzerMapper
implements XContentMapper {
    public static final String CONTENT_TYPE = "_analyzer";
    private final String path;

    public AnalyzerMapper() {
        this(CONTENT_TYPE);
    }

    public AnalyzerMapper(String path) {
        this.path = path;
    }

    @Override
    public String name() {
        return CONTENT_TYPE;
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        Analyzer analyzer = context.docMapper().mappers().indexAnalyzer();
        if (this.path != null) {
            String value = context.doc().get(this.path);
            if (value == null) {
                value = context.ignoredValue(this.path);
            }
            if (value != null) {
                analyzer = context.analysisService().analyzer(value);
                if (analyzer == null) {
                    throw new MapperParsingException("No analyzer found for [" + value + "] from path [" + this.path + "]");
                }
                analyzer = context.docMapper().mappers().indexAnalyzer(analyzer);
            }
        }
        context.analyzer(analyzer);
    }

    @Override
    public void merge(XContentMapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
    }

    @Override
    public void traverse(FieldMapperListener fieldMapperListener) {
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.path.equals(CONTENT_TYPE)) {
            return builder;
        }
        builder.startObject(CONTENT_TYPE);
        if (!this.path.equals(CONTENT_TYPE)) {
            builder.field("path", this.path);
        }
        builder.endObject();
        return builder;
    }

    public static class Builder
    extends XContentMapper.Builder<Builder, AnalyzerMapper> {
        private String field = "_analyzer";

        public Builder() {
            super(AnalyzerMapper.CONTENT_TYPE);
            this.builder = this;
        }

        public Builder field(String field) {
            this.field = field;
            return this;
        }

        @Override
        public AnalyzerMapper build(XContentMapper.BuilderContext context) {
            return new AnalyzerMapper(this.field);
        }
    }

    public static class Defaults {
        public static final String PATH = "_analyzer";
    }
}

