/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.merge.policy;

import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.merge.policy.BalancedSegmentMergePolicy;
import org.elasticsearch.index.merge.policy.MergePolicyProvider;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.store.Store;

public class BalancedSegmentMergePolicyProvider
extends AbstractIndexShardComponent
implements MergePolicyProvider<LogByteSizeMergePolicy> {
    private final ByteSizeValue minMergeSize;
    private final ByteSizeValue maxMergeSize;
    private final int mergeFactor;
    private final int maxMergeDocs;
    private final int numLargeSegments;
    private final int maxSmallSegments;

    @Inject
    public BalancedSegmentMergePolicyProvider(Store store) {
        super(store.shardId(), store.indexSettings());
        Preconditions.checkNotNull(store, "Store must be provided to merge policy");
        this.minMergeSize = this.componentSettings.getAsBytesSize("min_merge_size", new ByteSizeValue(0x100000L, ByteSizeUnit.BYTES));
        this.maxMergeSize = this.componentSettings.getAsBytesSize("max_merge_size", new ByteSizeValue(Long.MAX_VALUE, ByteSizeUnit.MB));
        this.mergeFactor = this.componentSettings.getAsInt("merge_factor", 10);
        this.maxMergeDocs = this.componentSettings.getAsInt("max_merge_docs", Integer.MAX_VALUE);
        this.numLargeSegments = this.componentSettings.getAsInt("num_large_segments", 10);
        this.maxSmallSegments = this.componentSettings.getAsInt("max_small_segments", 20);
        this.logger.debug("Using [balanced] merge policy with merge_factor[{}], min_merge_size[{}], max_merge_size[{}], max_merge_docs[{}]", this.mergeFactor, this.minMergeSize, this.maxMergeSize, this.maxMergeDocs);
    }

    @Override
    public BalancedSegmentMergePolicy newMergePolicy(IndexWriter indexWriter) {
        BalancedSegmentMergePolicy mergePolicy = new BalancedSegmentMergePolicy(indexWriter);
        mergePolicy.setMinMergeMB(this.minMergeSize.mbFrac());
        mergePolicy.setMaxMergeMB(this.maxMergeSize.mbFrac());
        mergePolicy.setMergeFactor(this.mergeFactor);
        mergePolicy.setMaxMergeDocs(this.maxMergeDocs);
        mergePolicy.setMaxSmallSegments(this.maxSmallSegments);
        mergePolicy.setNumLargeSegments(this.numLargeSegments);
        return mergePolicy;
    }
}

