/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.merge.scheduler;

import java.io.IOException;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.merge.policy.EnableMergePolicy;
import org.elasticsearch.index.merge.scheduler.MergeSchedulerProvider;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;

public class ConcurrentMergeSchedulerProvider
extends AbstractIndexShardComponent
implements MergeSchedulerProvider {
    private final int maxThreadCount;

    @Inject
    public ConcurrentMergeSchedulerProvider(ShardId shardId, @IndexSettings Settings indexSettings) {
        super(shardId, indexSettings);
        this.maxThreadCount = this.componentSettings.getAsInt("max_thread_count", Math.max(1, Math.min(3, Runtime.getRuntime().availableProcessors() / 2)));
        this.logger.debug("using [concurrent] merge scheduler with max_thread_count[{}]", this.maxThreadCount);
    }

    public MergeScheduler newMergeScheduler() {
        CustomConcurrentMergeScheduler concurrentMergeScheduler = new CustomConcurrentMergeScheduler(this.shardId);
        concurrentMergeScheduler.setMaxThreadCount(this.maxThreadCount);
        return concurrentMergeScheduler;
    }

    private static class CustomConcurrentMergeScheduler
    extends ConcurrentMergeScheduler {
        private final ShardId shardId;

        private CustomConcurrentMergeScheduler(ShardId shardId) {
            this.shardId = shardId;
        }

        public void merge(IndexWriter writer) throws CorruptIndexException, IOException {
            try {
                if (writer.getMergePolicy() instanceof EnableMergePolicy && !((EnableMergePolicy)writer.getMergePolicy()).isMergeEnabled()) {
                    return;
                }
            }
            catch (AlreadyClosedException e) {
                return;
            }
            super.merge(writer);
        }

        protected ConcurrentMergeScheduler.MergeThread getMergeThread(IndexWriter writer, MergePolicy.OneMerge merge) throws IOException {
            ConcurrentMergeScheduler.MergeThread thread = super.getMergeThread(writer, merge);
            thread.setName("[" + this.shardId.index().name() + "][" + this.shardId.id() + "]: " + thread.getName());
            return thread;
        }
    }
}

