/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.type.child;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.OpenBitSet;
import org.elasticsearch.common.BytesWrap;
import org.elasticsearch.index.cache.id.IdReaderTypeCache;
import org.elasticsearch.search.internal.SearchContext;

public class ChildCollector
extends Collector {
    private final String parentType;
    private final SearchContext context;
    private final Map<Object, IdReaderTypeCache> typeCacheMap;
    private final Map<Object, OpenBitSet> parentDocs;
    private IdReaderTypeCache typeCache;

    public ChildCollector(String parentType, SearchContext context) {
        this.parentType = parentType;
        this.context = context;
        this.parentDocs = new HashMap<Object, OpenBitSet>();
        this.typeCacheMap = new HashMap<Object, IdReaderTypeCache>(context.searcher().subReaders().length);
        for (IndexReader indexReader : context.searcher().subReaders()) {
            this.typeCacheMap.put(indexReader.getFieldCacheKey(), context.idCache().reader(indexReader).type(parentType));
        }
    }

    public Map<Object, OpenBitSet> parentDocs() {
        return this.parentDocs;
    }

    public void setScorer(Scorer scorer) throws IOException {
    }

    public void collect(int doc) throws IOException {
        BytesWrap parentId = this.typeCache.parentIdByDoc(doc);
        if (parentId == null) {
            return;
        }
        for (IndexReader indexReader : this.context.searcher().subReaders()) {
            int parentDocId = this.typeCacheMap.get(indexReader.getFieldCacheKey()).docById(parentId);
            if (parentDocId == -1 || indexReader.isDeleted(parentDocId)) continue;
            OpenBitSet docIdSet = this.parentDocs().get(indexReader.getFieldCacheKey());
            if (docIdSet == null) {
                docIdSet = new OpenBitSet((long)indexReader.maxDoc());
                this.parentDocs.put(indexReader.getFieldCacheKey(), docIdSet);
            }
            docIdSet.fastSet(parentDocId);
            return;
        }
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.typeCache = this.typeCacheMap.get(reader.getFieldCacheKey());
    }

    public boolean acceptsDocsOutOfOrder() {
        return true;
    }
}

