/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import org.apache.lucene.search.DeletionAwareConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.xcontent.QueryParseContext;
import org.elasticsearch.index.query.xcontent.XContentQueryParser;
import org.elasticsearch.index.settings.IndexSettings;

public class ConstantScoreQueryParser
extends AbstractIndexComponent
implements XContentQueryParser {
    public static final String NAME = "constant_score";

    @Inject
    public ConstantScoreQueryParser(Index index, @IndexSettings Settings settings) {
        super(index, settings);
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        Filter filter = null;
        float boost = 1.0f;
        boolean cache = false;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (!"filter".equals(currentFieldName)) continue;
                filter = parseContext.parseInnerFilter();
                continue;
            }
            if (!token.isValue()) continue;
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if (!"_cache".equals(currentFieldName)) continue;
            cache = parser.booleanValue();
        }
        if (filter == null) {
            throw new QueryParsingException(this.index, "[constant_score] requires 'filter' element");
        }
        if (cache) {
            filter = parseContext.cacheFilter(filter);
        }
        DeletionAwareConstantScoreQuery query = new DeletionAwareConstantScoreQuery(filter);
        query.setBoost(boost);
        return query;
    }
}

