/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanFirstQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.xcontent.QueryParseContext;
import org.elasticsearch.index.query.xcontent.XContentQueryParser;
import org.elasticsearch.index.settings.IndexSettings;

public class SpanFirstQueryParser
extends AbstractIndexComponent
implements XContentQueryParser {
    public static final String NAME = "span_first";

    @Inject
    public SpanFirstQueryParser(Index index, @IndexSettings Settings settings) {
        super(index, settings);
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        SpanFirstQuery query;
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        float boost = 1.0f;
        SpanQuery match = null;
        int end = -1;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (!"match".equals(currentFieldName)) continue;
                query = parseContext.parseInnerQuery();
                if (!(query instanceof SpanQuery)) {
                    throw new QueryParsingException(this.index, "spanFirst [match] must be of type span query");
                }
                match = (SpanQuery)query;
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if (!"end".equals(currentFieldName)) continue;
            end = parser.intValue();
        }
        if (match == null) {
            throw new QueryParsingException(this.index, "spanFirst must have [match] span query clause");
        }
        if (end == -1) {
            throw new QueryParsingException(this.index, "spanFirst must have [end] set for it");
        }
        query = new SpanFirstQuery(match, end);
        query.setBoost(boost);
        return query;
    }
}

