/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.type.child.TopChildrenQuery;
import org.elasticsearch.index.query.xcontent.QueryParseContext;
import org.elasticsearch.index.query.xcontent.XContentQueryParser;
import org.elasticsearch.index.settings.IndexSettings;

public class TopChildrenQueryParser
extends AbstractIndexComponent
implements XContentQueryParser {
    public static final String NAME = "top_children";

    @Inject
    public TopChildrenQueryParser(Index index, @IndexSettings Settings settings) {
        super(index, settings);
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        Query query = null;
        float boost = 1.0f;
        String childType = null;
        String scope = null;
        TopChildrenQuery.ScoreType scoreType = TopChildrenQuery.ScoreType.MAX;
        int factor = 5;
        int incrementalFactor = 2;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (!"query".equals(currentFieldName)) continue;
                query = parseContext.parseInnerQuery();
                continue;
            }
            if (!token.isValue()) continue;
            if ("type".equals(currentFieldName)) {
                childType = parser.text();
                continue;
            }
            if ("_scope".equals(currentFieldName)) {
                scope = parser.text();
                continue;
            }
            if ("score".equals(currentFieldName)) {
                scoreType = TopChildrenQuery.ScoreType.fromString(parser.text());
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("factor".equals(currentFieldName)) {
                factor = parser.intValue();
                continue;
            }
            if (!"incremental_factor".equals(currentFieldName) && !"incrementalFactor".equals(currentFieldName)) continue;
            incrementalFactor = parser.intValue();
        }
        if (query == null) {
            throw new QueryParsingException(this.index, "[child] requires 'query' field");
        }
        if (childType == null) {
            throw new QueryParsingException(this.index, "[child] requires 'type' field");
        }
        DocumentMapper childDocMapper = parseContext.mapperService().documentMapper(childType);
        if (childDocMapper == null) {
            throw new QueryParsingException(this.index, "No mapping for for type [" + childType + "]");
        }
        if (childDocMapper.parentFieldMapper() == null) {
            throw new QueryParsingException(this.index, "Type [" + childType + "] does not have parent mapping");
        }
        String parentType = childDocMapper.parentFieldMapper().type();
        query.setBoost(boost);
        query = new FilteredQuery(query, parseContext.cacheFilter(childDocMapper.typeFilter()));
        TopChildrenQuery childQuery = new TopChildrenQuery(query, scope, childType, parentType, scoreType, factor, incrementalFactor);
        parseContext.addScopePhase(childQuery);
        return childQuery;
    }
}

