/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.percolate;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.percolate.PercolateRequest;
import org.elasticsearch.action.percolate.PercolateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestPercolateAction
extends BaseRestHandler {
    @Inject
    public RestPercolateAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_percolate", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_percolate", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        PercolateRequest percolateRequest = new PercolateRequest(request.param("index"), request.param("type"));
        percolateRequest.source(request.contentByteArray(), request.contentByteArrayOffset(), request.contentLength(), request.contentUnsafe());
        percolateRequest.listenerThreaded(false);
        percolateRequest.operationThreaded(true);
        percolateRequest.preferLocal(request.paramAsBoolean("prefer_local", percolateRequest.preferLocalShard()));
        this.client.percolate(percolateRequest, new ActionListener<PercolateResponse>(){

            @Override
            public void onResponse(PercolateResponse response) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject();
                    builder.field(Fields.OK, true);
                    builder.startArray(Fields.MATCHES);
                    for (String match : response) {
                        builder.value(match);
                    }
                    builder.endArray();
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestPercolateAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }

    static final class Fields {
        static final XContentBuilderString OK = new XContentBuilderString("ok");
        static final XContentBuilderString MATCHES = new XContentBuilderString("matches");

        Fields() {
        }
    }
}

